/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import org.conscrypt.OpenSSLX25519Key;

public class OpenSSLX25519PublicKey
implements OpenSSLX25519Key,
PublicKey {
    private static final long serialVersionUID = 453861992373478445L;
    private static final byte[] X509_PREAMBLE = new byte[]{48, 42, 48, 5, 6, 3, 43, 101, 110, 3, 33, 0};
    private static final byte[] X509_PREAMBLE_WITH_NULL = new byte[]{48, 44, 48, 7, 6, 3, 43, 101, 110, 5, 0, 3, 33, 0};
    private final byte[] uCoordinate;

    public OpenSSLX25519PublicKey(X509EncodedKeySpec keySpec) throws InvalidKeySpecException {
        byte[] encoded = keySpec.getEncoded();
        if (encoded == null || !"X.509".equals(keySpec.getFormat())) {
            throw new InvalidKeySpecException("Encoding must be in X.509 format");
        }
        int preambleLength = OpenSSLX25519PublicKey.matchesPreamble(X509_PREAMBLE, encoded) | OpenSSLX25519PublicKey.matchesPreamble(X509_PREAMBLE_WITH_NULL, encoded);
        if (preambleLength == 0) {
            throw new InvalidKeySpecException("Key size is not correct size");
        }
        this.uCoordinate = Arrays.copyOfRange(encoded, preambleLength, encoded.length);
    }

    private static int matchesPreamble(byte[] preamble, byte[] encoded) {
        if (encoded.length != preamble.length + 32) {
            return 0;
        }
        int cmp = 0;
        for (int i = 0; i < preamble.length; ++i) {
            cmp |= encoded[i] ^ preamble[i];
        }
        if (cmp != 0) {
            return 0;
        }
        return preamble.length;
    }

    public OpenSSLX25519PublicKey(byte[] coordinateBytes) {
        this.uCoordinate = (byte[])coordinateBytes.clone();
    }

    @Override
    public String getAlgorithm() {
        return "XDH";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        if (this.uCoordinate == null) {
            throw new IllegalStateException("key is destroyed");
        }
        byte[] encoded = Arrays.copyOf(X509_PREAMBLE, X509_PREAMBLE.length + 32);
        System.arraycopy(this.uCoordinate, 0, encoded, X509_PREAMBLE.length, this.uCoordinate.length);
        return encoded;
    }

    @Override
    public byte[] getU() {
        if (this.uCoordinate == null) {
            throw new IllegalStateException("key is destroyed");
        }
        return (byte[])this.uCoordinate.clone();
    }

    public boolean equals(Object o) {
        if (this.uCoordinate == null) {
            throw new IllegalStateException("key is destroyed");
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenSSLX25519PublicKey)) {
            return false;
        }
        OpenSSLX25519PublicKey that = (OpenSSLX25519PublicKey)o;
        return Arrays.equals(this.uCoordinate, that.uCoordinate);
    }

    public int hashCode() {
        if (this.uCoordinate == null) {
            throw new IllegalStateException("key is destroyed");
        }
        return Arrays.hashCode(this.uCoordinate);
    }
}

