/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util;

import java.text.BreakIterator;
import java.util.Iterator;

public class StringWrapper {
    public static Iterable<String> wrapStringOnBreaks(final String string, final int maxWidth) {
        final BreakIterator breakIterator = BreakIterator.getLineInstance();
        breakIterator.setText(string);
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    private int currentLineStart = 0;
                    private boolean nextLineSet = false;
                    private String nextLine;

                    @Override
                    public boolean hasNext() {
                        if (!this.nextLineSet) {
                            this.calculateNext();
                        }
                        return this.nextLine != null;
                    }

                    private void calculateNext() {
                        int lineEnd;
                        block5: {
                            lineEnd = this.currentLineStart;
                            do {
                                if ((lineEnd = breakIterator.following(lineEnd)) == -1) {
                                    lineEnd = breakIterator.last();
                                    if (lineEnd <= this.currentLineStart) {
                                        this.nextLine = null;
                                        this.nextLineSet = true;
                                        return;
                                    }
                                } else {
                                    if (lineEnd - this.currentLineStart <= maxWidth) continue;
                                    if ((lineEnd = breakIterator.preceding(lineEnd)) <= this.currentLineStart) {
                                        lineEnd = this.currentLineStart + maxWidth;
                                    }
                                }
                                break block5;
                            } while (string.charAt(lineEnd - 1) != '\n');
                            this.nextLine = string.substring(this.currentLineStart, lineEnd - 1);
                            this.nextLineSet = true;
                            this.currentLineStart = lineEnd;
                            return;
                        }
                        this.nextLine = string.substring(this.currentLineStart, lineEnd);
                        this.nextLineSet = true;
                        this.currentLineStart = lineEnd;
                    }

                    @Override
                    public String next() {
                        String ret = this.nextLine;
                        this.nextLine = null;
                        this.nextLineSet = false;
                        return ret;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

