/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.immutable;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.jf.dexlib2.base.BaseAnnotation;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.AnnotationElement;
import org.jf.dexlib2.immutable.ImmutableAnnotationElement;
import org.jf.util.ImmutableConverter;

public class ImmutableAnnotation
extends BaseAnnotation {
    protected final int visibility;
    protected final String type;
    protected final ImmutableSet<? extends ImmutableAnnotationElement> elements;
    private static final ImmutableConverter<ImmutableAnnotation, Annotation> CONVERTER = new ImmutableConverter<ImmutableAnnotation, Annotation>(){

        @Override
        protected boolean isImmutable(Annotation item) {
            return item instanceof ImmutableAnnotation;
        }

        @Override
        protected ImmutableAnnotation makeImmutable(Annotation item) {
            return ImmutableAnnotation.of(item);
        }
    };

    public ImmutableAnnotation(int visibility, String type, Collection<? extends AnnotationElement> elements) {
        this.visibility = visibility;
        this.type = type;
        this.elements = ImmutableAnnotationElement.immutableSetOf(elements);
    }

    public static ImmutableAnnotation of(Annotation annotation) {
        if (annotation instanceof ImmutableAnnotation) {
            return (ImmutableAnnotation)annotation;
        }
        return new ImmutableAnnotation(annotation.getVisibility(), annotation.getType(), annotation.getElements());
    }

    @Override
    public int getVisibility() {
        return this.visibility;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public ImmutableSet<? extends ImmutableAnnotationElement> getElements() {
        return this.elements;
    }
}

