/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.builder.instruction;

import org.jf.dexlib2.Format;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.builder.BuilderInstruction;
import org.jf.dexlib2.iface.instruction.formats.Instruction3rmi;
import org.jf.dexlib2.util.Preconditions;

public class BuilderInstruction3rmi
extends BuilderInstruction
implements Instruction3rmi {
    public static final Format FORMAT = Format.Format3rmi;
    protected final int startRegister;
    protected final int registerCount;
    protected final int inlineIndex;

    public BuilderInstruction3rmi(Opcode opcode, int startRegister, int registerCount, int inlineIndex) {
        super(opcode);
        this.startRegister = Preconditions.checkShortRegister(startRegister);
        this.registerCount = Preconditions.checkRegisterRangeCount(registerCount);
        this.inlineIndex = inlineIndex;
    }

    @Override
    public int getStartRegister() {
        return this.startRegister;
    }

    @Override
    public int getRegisterCount() {
        return this.registerCount;
    }

    @Override
    public int getInlineIndex() {
        return this.inlineIndex;
    }

    @Override
    public Format getFormat() {
        return FORMAT;
    }
}

