/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.raw.ItemType;
import org.jf.dexlib2.dexbacked.raw.SectionAnnotator;
import org.jf.dexlib2.dexbacked.raw.util.DexAnnotator;
import org.jf.dexlib2.util.AnnotatedBytes;

public class MapItem {
    private final DexBackedDexFile dexFile;
    private final int offset;

    public MapItem(DexBackedDexFile dexFile, int offset) {
        this.dexFile = dexFile;
        this.offset = offset;
    }

    public int getType() {
        return this.dexFile.getDataBuffer().readUshort(this.offset + 0);
    }

    public int getItemCount() {
        return this.dexFile.getDataBuffer().readSmallUint(this.offset + 4);
    }

    public int getOffset() {
        return this.dexFile.getDataBuffer().readSmallUint(this.offset + 8);
    }

    public static SectionAnnotator makeAnnotator(DexAnnotator annotator, MapItem mapItem) {
        return new SectionAnnotator(annotator, mapItem){

            @Override
            public String getItemName() {
                return "map_item";
            }

            @Override
            protected void annotateItem(AnnotatedBytes out, int itemIndex, String itemIdentity) {
                int itemType = this.dexFile.getBuffer().readUshort(out.getCursor());
                out.annotate(2, "type = 0x%x: %s", itemType, ItemType.getItemTypeName(itemType));
                out.annotate(2, "unused", new Object[0]);
                int size = this.dexFile.getBuffer().readSmallUint(out.getCursor());
                out.annotate(4, "size = %d", size);
                int offset = this.dexFile.getBuffer().readSmallUint(out.getCursor());
                out.annotate(4, "offset = 0x%x", offset);
            }

            @Override
            public void annotateSection(AnnotatedBytes out) {
                out.moveTo(this.sectionOffset);
                int mapItemCount = this.dexFile.getBuffer().readSmallUint(out.getCursor());
                out.annotate(4, "size = %d", mapItemCount);
                super.annotateSectionInner(out, mapItemCount);
            }
        };
    }
}

