/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jf.util.collection.ArraySet;

public class ListUtil {
    private static final NaturalSort NATURAL_SORT = new NaturalSort(false);
    private static final NaturalSort INVERT_SORT = new NaturalSort(false);
    private static final Comparator<?> TO_STRING_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object obj1, Object obj2) {
            return String.valueOf(obj1).compareTo(String.valueOf(obj2));
        }
    };

    public static <E, T> List<T> transform(Collection<E> collection, Function<? super E, ? extends T> function, int limit) {
        ArrayList<T> results = new ArrayList<T>(collection.size());
        for (E input : collection) {
            if (results.size() >= limit) break;
            results.add(function.apply(input));
        }
        return results;
    }

    public static <E, T> List<T> transform(Collection<E> collection, Function<? super E, ? extends T> function) {
        ArrayList<T> results = new ArrayList<T>(collection.size());
        for (E input : collection) {
            results.add(function.apply(input));
        }
        return results;
    }

    public static <E> ArrayList<E> of() {
        return ListUtil.of(null);
    }

    public static <E> ArrayList<E> of(E ... elements) {
        return ListUtil.newArrayList(elements);
    }

    public static <E> ArrayList<E> newArrayList(Iterable<? extends E> elements) {
        if (elements == null) {
            return new ArrayList(1);
        }
        if (elements instanceof Collection) {
            return ListUtil.newArrayList((Collection)elements);
        }
        return ListUtil.newArrayList(elements.iterator());
    }

    public static <E> ArrayList<E> newArrayList(Collection<? extends E> elements) {
        if (elements == null) {
            return new ArrayList(1);
        }
        return new ArrayList<E>(elements);
    }

    public static <E> ArrayList<E> newArrayList(Iterator<? extends E> elements) {
        if (elements == null) {
            return new ArrayList(1);
        }
        ArrayList<E> list = new ArrayList<E>();
        while (elements.hasNext()) {
            list.add(elements.next());
        }
        return list;
    }

    public static <T> List<T> reverse(List<T> list) {
        ArrayList<T> results = new ArrayList<T>(list.size());
        for (int i = list.size() - 1; i >= 0; --i) {
            results.add(list.get(i));
        }
        return results;
    }

    public static <T> void addAll(List<T> destination, Iterable<T> iterable) {
        if (iterable == null || iterable == destination) {
            return;
        }
        ListUtil.addAll(destination, iterable.iterator());
    }

    public static <T> void addAll(List<T> destination, Iterator<T> iterator) {
        while (iterator.hasNext()) {
            destination.add(iterator.next());
        }
    }

    public static <E> ArrayList<E> newArrayList() {
        return new ArrayList(1);
    }

    public static <E> ArrayList<E> newArrayList(E ... elements) {
        int capacity = 0;
        if (elements != null) {
            capacity = elements.length;
        }
        if (capacity == 0) {
            capacity = 1;
        }
        ArrayList list = new ArrayList(capacity);
        if (elements != null) {
            Collections.addAll(list, elements);
        }
        return list;
    }

    public static <T> List<T> sortedCopy(Collection<T> collection, Comparator<? super T> comparator) {
        ArrayList<T> result = new ArrayList<T>(collection);
        result.sort(comparator);
        return result;
    }

    public static <T> List<T> nullToEmptySet(List<T> list) {
        if (list == null) {
            return ListUtil.of(null);
        }
        return list;
    }

    public static <T> List<T> nullToEmptyList(List<T> list) {
        if (list == null) {
            return ListUtil.of(null);
        }
        return list;
    }

    public static <T> Set<T> immutableSetOf(Iterable<? extends T> iterable) {
        if (iterable == null) {
            return ArraySet.of();
        }
        return ArraySet.copyOf(iterable.iterator());
    }

    public static <T> List<T> copyOf(Collection<T> collection) {
        if (collection == null) {
            return new ArrayList(1);
        }
        return new ArrayList<T>(collection);
    }

    public static <T> List<T> copyOf(Iterable<? extends T> iterable) {
        if (iterable == null) {
            return new ArrayList(1);
        }
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            return ListUtil.copyOf(collection);
        }
        return ListUtil.copyOf(iterable.iterator());
    }

    public static <T> List<T> copyOf(Iterator<? extends T> iterator) {
        ArrayList<T> result = new ArrayList<T>();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    public static <T extends Comparable<?>> Collection<T> sortedCopy(Iterator<? extends T> iterator) {
        return ArraySet.sortedCopy(iterator);
    }

    public static <T extends Comparable<?>> List<T> sortedCopy(Collection<? extends T> collection) {
        return ListUtil.sortedCopy(collection, false);
    }

    public static <T extends Comparable<?>> List<T> sortedCopy(Collection<? extends T> collection, boolean invert) {
        ArrayList<T> results = new ArrayList<T>(collection);
        if (invert) {
            results.sort(INVERT_SORT);
        } else {
            results.sort(NATURAL_SORT);
        }
        return results;
    }

    public static <T> Comparator<T> toStringComparator() {
        return TO_STRING_COMPARATOR;
    }

    private static class NaturalSort<T extends Comparable<T>>
    implements Comparator<T> {
        private final boolean isInvert;

        NaturalSort(boolean isInvert) {
            this.isInvert = isInvert;
        }

        @Override
        public int compare(T t1, T t2) {
            if (this.isInvert) {
                return t2.compareTo(t1);
            }
            return t1.compareTo(t2);
        }
    }
}

