/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class FilterIterator<E, T extends E>
implements Iterator<T> {
    private final Iterator<? extends T> iterator;
    private T mNext;
    private boolean mNextComputed;
    private final Predicate<E> filter;

    public FilterIterator(Iterator<? extends T> iterator, Predicate<E> filter) {
        this.iterator = iterator;
        this.filter = filter;
    }

    @Override
    public boolean hasNext() {
        this.getNext();
        return this.mNextComputed;
    }

    @Override
    public T next() {
        T item = this.getNext();
        if (!this.mNextComputed) {
            throw new NoSuchElementException();
        }
        this.mNextComputed = false;
        this.mNext = null;
        return item;
    }

    private T getNext() {
        if (!this.mNextComputed) {
            while (this.iterator.hasNext()) {
                T item = this.iterator.next();
                if (!this.testAll(item)) continue;
                this.mNext = item;
                this.mNextComputed = true;
                break;
            }
        }
        return this.mNext;
    }

    private boolean testAll(T item) {
        if (this.filter == null) {
            return true;
        }
        return this.filter.test(item);
    }
}

