/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.util;

import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.base.value.BaseArrayEncodedValue;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.value.ArrayEncodedValue;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableEncodedValueFactory;
import org.jf.dexlib2.util.EncodedValueUtils;
import org.jf.util.CollectionUtils;
import org.jf.util.collection.ListUtil;

public class StaticInitializerUtil {
    private static final Predicate<Field> HAS_INITIALIZER = new Predicate<Field>(){

        @Override
        public boolean test(Field input) {
            EncodedValue encodedValue = input.getInitialValue();
            return encodedValue != null && !EncodedValueUtils.isDefaultValue(encodedValue);
        }
    };
    private static final Function<Field, EncodedValue> GET_INITIAL_VALUE = new Function<Field, EncodedValue>(){

        @Override
        public EncodedValue apply(Field input) {
            EncodedValue initialValue = input.getInitialValue();
            if (initialValue == null) {
                return ImmutableEncodedValueFactory.defaultValueForType(input.getType());
            }
            return initialValue;
        }
    };

    @Nullable
    public static ArrayEncodedValue getStaticInitializers(final @Nonnull Set<? extends Field> sortedStaticFields) {
        final int lastIndex = CollectionUtils.lastIndexOf(sortedStaticFields, HAS_INITIALIZER);
        if (lastIndex > -1) {
            return new BaseArrayEncodedValue(){

                @Override
                @Nonnull
                public List<? extends EncodedValue> getValue() {
                    return ListUtil.transform(sortedStaticFields, GET_INITIAL_VALUE, lastIndex + 1);
                }
            };
        }
        return null;
    }
}

