/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nonnull;
import org.jf.dexlib2.writer.io.DeferredOutputStream;
import org.jf.dexlib2.writer.io.DeferredOutputStreamFactory;
import org.jf.util.collection.ListUtil;

public class MemoryDeferredOutputStream
extends DeferredOutputStream {
    private static final int DEFAULT_BUFFER_SIZE = 16384;
    private final List<byte[]> buffers = ListUtil.newArrayList();
    private byte[] currentBuffer;
    private int currentPosition;

    public MemoryDeferredOutputStream() {
        this(16384);
    }

    public MemoryDeferredOutputStream(int bufferSize) {
        this.currentBuffer = new byte[bufferSize];
    }

    @Override
    public void writeTo(OutputStream output) throws IOException {
        for (byte[] buffer : this.buffers) {
            output.write(buffer);
        }
        if (this.currentPosition > 0) {
            output.write(this.currentBuffer, 0, this.currentPosition);
        }
        this.buffers.clear();
        this.currentPosition = 0;
    }

    @Override
    public void write(int i) throws IOException {
        if (this.remaining() == 0) {
            this.buffers.add(this.currentBuffer);
            this.currentBuffer = new byte[this.currentBuffer.length];
            this.currentPosition = 0;
        }
        this.currentBuffer[this.currentPosition++] = (byte)i;
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        int remaining = this.remaining();
        int written = 0;
        while (length - written > 0) {
            int toWrite = Math.min(remaining, length - written);
            System.arraycopy(bytes, offset + written, this.currentBuffer, this.currentPosition, toWrite);
            written += toWrite;
            this.currentPosition += toWrite;
            remaining = this.remaining();
            if (remaining != 0) continue;
            this.buffers.add(this.currentBuffer);
            this.currentBuffer = new byte[this.currentBuffer.length];
            this.currentPosition = 0;
            remaining = this.currentBuffer.length;
        }
    }

    private int remaining() {
        return this.currentBuffer.length - this.currentPosition;
    }

    @Nonnull
    public static DeferredOutputStreamFactory getFactory() {
        return MemoryDeferredOutputStream.getFactory(16384);
    }

    @Nonnull
    public static DeferredOutputStreamFactory getFactory(final int bufferSize) {
        return new DeferredOutputStreamFactory(){

            @Override
            public DeferredOutputStream makeDeferredOutputStream() {
                return new MemoryDeferredOutputStream(bufferSize);
            }
        };
    }
}

