/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.immutable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.extra.DexMarker;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.immutable.ImmutableClassDef;
import org.jf.util.ImmutableUtils;

public class ImmutableDexFile
implements DexFile {
    @Nonnull
    protected final Set<? extends ImmutableClassDef> classes;
    @Nonnull
    private final Opcodes opcodes;
    private List<DexMarker> markerList;

    public ImmutableDexFile(@Nonnull Opcodes opcodes, @Nullable Collection<? extends ClassDef> classes) {
        this.classes = ImmutableClassDef.immutableSetOf(classes);
        this.opcodes = opcodes;
    }

    public ImmutableDexFile(@Nonnull Opcodes opcodes, @Nullable Set<? extends ImmutableClassDef> classes) {
        this.classes = ImmutableUtils.nullToEmptySet(classes);
        this.opcodes = opcodes;
    }

    public static ImmutableDexFile of(DexFile dexFile) {
        if (dexFile instanceof ImmutableDexFile) {
            return (ImmutableDexFile)dexFile;
        }
        ImmutableDexFile immutableDexFile = new ImmutableDexFile(dexFile.getOpcodes(), (Collection<? extends ClassDef>)dexFile.getClasses());
        immutableDexFile.setMarkerList(dexFile.getMarkers());
        return immutableDexFile;
    }

    public void setMarkerList(List<DexMarker> markerList) {
        this.markerList = markerList;
    }

    @Override
    public List<DexMarker> getMarkers() {
        if (this.markerList == null) {
            this.markerList = new ArrayList<DexMarker>();
        }
        return this.markerList;
    }

    @Nonnull
    public Set<? extends ImmutableClassDef> getClasses() {
        return this.classes;
    }

    @Override
    @Nonnull
    public Opcodes getOpcodes() {
        return this.opcodes;
    }
}

