/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.reference;

import java.util.List;
import javax.annotation.Nonnull;
import org.jf.dexlib2.base.reference.BaseMethodReference;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.util.FixedSizeList;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.util.collection.EmptyList;

public class DexBackedMethodReference
extends BaseMethodReference {
    @Nonnull
    public final DexBackedDexFile dexFile;
    private final int methodIndex;
    private int protoIdItemOffset;

    public DexBackedMethodReference(@Nonnull DexBackedDexFile dexFile, int methodIndex) {
        this.dexFile = dexFile;
        this.methodIndex = methodIndex;
    }

    @Override
    @Nonnull
    public String getDefiningClass() {
        return this.dexFile.getTypeSection().get(this.dexFile.getBuffer().readUshort(this.dexFile.getMethodSection().getOffset(this.methodIndex) + 0));
    }

    @Override
    @Nonnull
    public String getName() {
        return this.dexFile.getStringSection().get(this.dexFile.getBuffer().readSmallUint(this.dexFile.getMethodSection().getOffset(this.methodIndex) + 4));
    }

    @Nonnull
    public List<String> getParameterTypes() {
        int protoIdItemOffset = this.getProtoIdItemOffset();
        int parametersOffset = this.dexFile.getBuffer().readSmallUint(protoIdItemOffset + 8);
        if (parametersOffset > 0) {
            final int parameterCount = this.dexFile.getDataBuffer().readSmallUint(parametersOffset + 0);
            final int paramListStart = parametersOffset + 4;
            return new FixedSizeList<String>(){

                @Override
                @Nonnull
                public String readItem(int index) {
                    return DexBackedMethodReference.this.dexFile.getTypeSection().get(DexBackedMethodReference.this.dexFile.getDataBuffer().readUshort(paramListStart + 2 * index));
                }

                @Override
                public int size() {
                    return parameterCount;
                }
            };
        }
        return EmptyList.of();
    }

    @Override
    @Nonnull
    public String getReturnType() {
        int protoIdItemOffset = this.getProtoIdItemOffset();
        return this.dexFile.getTypeSection().get(this.dexFile.getBuffer().readSmallUint(protoIdItemOffset + 4));
    }

    private int getProtoIdItemOffset() {
        if (this.protoIdItemOffset == 0) {
            this.protoIdItemOffset = this.dexFile.getProtoSection().getOffset(this.dexFile.getBuffer().readUshort(this.dexFile.getMethodSection().getOffset(this.methodIndex) + 2));
        }
        return this.protoIdItemOffset;
    }

    public int getSize() {
        return 8;
    }

    @Override
    public void validateReference() throws Reference.InvalidReferenceException {
        if (this.methodIndex < 0 || this.methodIndex >= this.dexFile.getMethodSection().size()) {
            throw new Reference.InvalidReferenceException("method@" + this.methodIndex);
        }
    }
}

