/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.model;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.jf.dexlib2.dexbacked.DexBuffer;
import org.jf.dexlib2.dexbacked.DexReader;
import org.jf.dexlib2.dexbacked.model.DexString;
import org.jf.util.collection.ArrayIterator;
import org.jf.util.collection.ArrayListIterator;
import org.jf.util.collection.ComputingList;

public class DexStringSection
implements List<DexString>,
Function<DexString, String> {
    private final DexString[] array;
    private final List<String> stringList;

    public DexStringSection(int size) {
        this.array = new DexString[size];
        this.stringList = new ComputingList<DexString, String>(this, this);
    }

    public void load(DexBuffer dexBuffer, int offset, int item_size) {
        DexString[] array = this.array;
        int count = array.length;
        DexReader<? extends DexBuffer> reader = dexBuffer.readerAt(offset);
        for (int i = 0; i < count; ++i) {
            int stringOffset = offset + i * item_size;
            int stringDataOffset = dexBuffer.readSmallUint(stringOffset);
            reader.setOffset(stringDataOffset);
            int utf16Length = reader.readSmallUleb128();
            String value = reader.readString(utf16Length);
            array[i] = new DexString(this, i, value);
        }
    }

    public List<String> getStringList() {
        return this.stringList;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean isEmpty() {
        return this.array.length == 0;
    }

    @Override
    public boolean contains(Object obj) {
        if (obj instanceof DexString) {
            return this.contains((DexString)obj);
        }
        return false;
    }

    public boolean contains(DexString dexString) {
        if (dexString == null) {
            return false;
        }
        if (dexString.getStringSection() != this) {
            return false;
        }
        int index = dexString.getIndex();
        if (index < 0 || index >= this.size()) {
            return false;
        }
        return this.get(index) == dexString;
    }

    @Override
    @Nonnull
    public Iterator<DexString> iterator() {
        return new ArrayIterator<DexString>(this.array);
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        return (Object[])this.array.clone();
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        return ts;
    }

    @Override
    public boolean add(DexString dexString) {
        return false;
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends DexString> collection) {
        return false;
    }

    @Override
    public boolean addAll(int i, Collection<? extends DexString> collection) {
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return false;
    }

    @Override
    public void clear() {
    }

    @Override
    public DexString get(int i) {
        if (i < 0) {
            return null;
        }
        return this.array[i];
    }

    @Override
    public DexString set(int i, DexString dexString) {
        return null;
    }

    @Override
    public void add(int i, DexString dexString) {
        this.array[i] = dexString;
    }

    @Override
    public DexString remove(int i) {
        return null;
    }

    @Override
    public int indexOf(Object obj) {
        if (obj instanceof DexString) {
            return ((DexString)obj).getIndex();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object obj) {
        if (obj instanceof DexString) {
            return ((DexString)obj).getIndex();
        }
        return -1;
    }

    @Override
    public ListIterator<DexString> listIterator() {
        return new ArrayListIterator<DexString>(this.array);
    }

    @Override
    public ListIterator<DexString> listIterator(int i) {
        return new ArrayListIterator<DexString>(this.array, i);
    }

    @Override
    public List<DexString> subList(int i, int i1) {
        return null;
    }

    @Override
    public String apply(DexString dexString) {
        if (dexString != null) {
            return dexString.getValue();
        }
        return null;
    }
}

