/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.jf.util.ExceptionWithContext;

public class MethodHandleType {
    public static final int STATIC_PUT = 0;
    public static final int STATIC_GET = 1;
    public static final int INSTANCE_PUT = 2;
    public static final int INSTANCE_GET = 3;
    public static final int INVOKE_STATIC = 4;
    public static final int INVOKE_INSTANCE = 5;
    public static final int INVOKE_CONSTRUCTOR = 6;
    public static final int INVOKE_DIRECT = 7;
    public static final int INVOKE_INTERFACE = 8;
    private static final Map<Integer, String> methodHandleTypeNames = new HashMap<Integer, String>();
    private static final Map<String, Integer> typeNamesMethodHandle;

    @Nonnull
    public static String toString(int methodHandleType) {
        String val = methodHandleTypeNames.get(methodHandleType);
        if (val == null) {
            throw new InvalidMethodHandleTypeException(methodHandleType);
        }
        return val;
    }

    public static int getMethodHandleType(String methodHandleType) {
        Integer ret = typeNamesMethodHandle.get(methodHandleType);
        if (ret == null) {
            throw new ExceptionWithContext("Invalid method handle type: %s", methodHandleType);
        }
        return ret;
    }

    static {
        methodHandleTypeNames.put(0, "static-put");
        methodHandleTypeNames.put(1, "static-get");
        methodHandleTypeNames.put(2, "instance-put");
        methodHandleTypeNames.put(3, "instance-get");
        methodHandleTypeNames.put(4, "invoke-static");
        methodHandleTypeNames.put(5, "invoke-instance");
        methodHandleTypeNames.put(6, "invoke-constructor");
        methodHandleTypeNames.put(7, "invoke-direct");
        methodHandleTypeNames.put(8, "invoke-interface");
        typeNamesMethodHandle = new HashMap<String, Integer>();
        typeNamesMethodHandle.put("static-put", 0);
        typeNamesMethodHandle.put("static-get", 1);
        typeNamesMethodHandle.put("instance-put", 2);
        typeNamesMethodHandle.put("instance-get", 3);
        typeNamesMethodHandle.put("invoke-static", 4);
        typeNamesMethodHandle.put("invoke-instance", 5);
        typeNamesMethodHandle.put("invoke-constructor", 6);
        typeNamesMethodHandle.put("invoke-direct", 7);
        typeNamesMethodHandle.put("invoke-interface", 8);
    }

    public static class InvalidMethodHandleTypeException
    extends ExceptionWithContext {
        private final int methodHandleType;

        public InvalidMethodHandleTypeException(int methodHandleType) {
            super("Invalid method handle type: %d", methodHandleType);
            this.methodHandleType = methodHandleType;
        }

        public InvalidMethodHandleTypeException(int methodHandleType, String message, Object ... formatArgs) {
            super(message, formatArgs);
            this.methodHandleType = methodHandleType;
        }

        public int getMethodHandleType() {
            return this.methodHandleType;
        }
    }
}

