/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import java.io.Closeable;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XmlParserToSerializer {
    private final XmlSerializer serializer;
    private final XmlPullParser parser;
    private boolean enableIndent;
    boolean processNamespace;
    boolean reportNamespaceAttrs;
    private static final String FEATURE_INDENT_OUTPUT = "http://xmlpull.org/v1/doc/features.html#indent-output";

    public XmlParserToSerializer(XmlPullParser parser, XmlSerializer serializer) {
        this.parser = parser;
        this.serializer = serializer;
        this.enableIndent = true;
        XmlParserToSerializer.setFeatureSafe(parser, "http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        XmlParserToSerializer.setFeatureSafe(parser, "http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes", true);
    }

    public void setEnableIndent(boolean enableIndent) {
        this.enableIndent = enableIndent;
    }

    public void write() throws IOException, XmlPullParserException {
        XmlPullParser parser = this.parser;
        this.processNamespace = XmlParserToSerializer.getFeatureSafe(parser, "http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
        this.reportNamespaceAttrs = XmlParserToSerializer.getFeatureSafe(parser, "http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes", false);
        int event = parser.next();
        while (this.nextEvent(event)) {
            event = parser.next();
        }
        this.close();
    }

    private void close() throws IOException {
        XmlSerializer serializer;
        XmlPullParser parser = this.parser;
        if (parser instanceof Closeable) {
            ((Closeable)((Object)parser)).close();
        }
        if ((serializer = this.serializer) instanceof Closeable) {
            ((Closeable)((Object)serializer)).close();
        }
    }

    private boolean nextEvent(int event) throws IOException, XmlPullParserException {
        boolean hasNext = true;
        switch (event) {
            case 0: {
                this.onStartDocument();
                break;
            }
            case 2: {
                this.onStartTag();
                break;
            }
            case 4: {
                this.onText();
                break;
            }
            case 9: {
                this.onComment();
                break;
            }
            case 3: {
                this.onEndTag();
                break;
            }
            case 1: {
                this.onEndDocument();
                hasNext = false;
            }
        }
        return hasNext;
    }

    private void onStartDocument() throws IOException {
        this.serializer.startDocument("utf-8", null);
    }

    private void onStartTag() throws IOException, XmlPullParserException {
        int i;
        boolean countNamespaceAsAttribute;
        XmlPullParser parser = this.parser;
        XmlSerializer serializer = this.serializer;
        boolean processNamespace = this.processNamespace;
        boolean bl = countNamespaceAsAttribute = processNamespace && this.reportNamespaceAttrs;
        if (this.enableIndent) {
            XmlParserToSerializer.setFeatureSafe(serializer, FEATURE_INDENT_OUTPUT, true);
        }
        if (!countNamespaceAsAttribute) {
            int nsCount = parser.getNamespaceCount(parser.getDepth());
            for (i = 0; i < nsCount; ++i) {
                String prefix = parser.getNamespacePrefix(i);
                String namespace = parser.getNamespaceUri(i);
                serializer.setPrefix(prefix, namespace);
            }
        }
        serializer.startTag(parser.getNamespace(), parser.getName());
        int attrCount = parser.getAttributeCount();
        for (i = 0; i < attrCount; ++i) {
            String namespace = processNamespace ? parser.getAttributeNamespace(i) : null;
            serializer.attribute(namespace, parser.getAttributeName(i), parser.getAttributeValue(i));
        }
    }

    private void onText() throws IOException {
        this.serializer.text(this.parser.getText());
    }

    private void onComment() throws IOException {
        this.serializer.comment(this.parser.getText());
    }

    private void onEndTag() throws IOException {
        this.serializer.endTag(this.parser.getNamespace(), this.parser.getName());
    }

    private void onEndDocument() throws IOException {
        this.serializer.endDocument();
    }

    private static boolean getFeatureSafe(XmlPullParser parser, String name, boolean def) {
        try {
            return parser.getFeature(name);
        }
        catch (Throwable ignored) {
            return def;
        }
    }

    private static void setFeatureSafe(XmlPullParser parser, String name, boolean state) {
        try {
            parser.setFeature(name, state);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void setFeatureSafe(XmlSerializer serializer, String name, boolean state) {
        try {
            serializer.setFeature(name, state);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

