/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XMLUtil {
    public static String[] EVENT_TYPES = new String[]{"START_DOCUMENT", "END_DOCUMENT", "START_TAG", "END_TAG", "TEXT", "CDSECT", "ENTITY_REF", "IGNORABLE_WHITESPACE", "PROCESSING_INSTRUCTION", "COMMENT", "DOCDECL"};

    public static String decodeEntityRef(String text) {
        if (text == null || text.length() == 0) {
            return "";
        }
        if ("lt".equals(text)) {
            return "<";
        }
        if ("gt".equals(text)) {
            return ">";
        }
        if ("amp".equals(text)) {
            return "&";
        }
        if ("quot".equals(text)) {
            return "\"";
        }
        if ("apos".equals(text)) {
            return "'";
        }
        if (text.charAt(0) == '#') {
            try {
                char ch = (char)Integer.parseInt(text.substring(1));
                return String.valueOf(ch);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return text;
    }

    public static String splitName(String name) {
        if (name == null) {
            return null;
        }
        int i = name.lastIndexOf(58);
        if (i >= 0) {
            name = name.substring(++i);
        }
        if ((name = name.trim()).length() == 0) {
            return null;
        }
        return name;
    }

    public static String splitPrefix(String name) {
        if (name == null) {
            return null;
        }
        int i = name.indexOf(58);
        if (i > 0) {
            return name.substring(0, i);
        }
        return null;
    }

    public static int ensureStartTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int event = parser.getEventType();
        while (event != 2 && event != 1) {
            event = parser.next();
        }
        return event;
    }

    public static boolean isEmpty(String s) {
        if (s == null) {
            return true;
        }
        return s.length() == 0;
    }

    public static String escapeXmlChars(String str) {
        if (str == null) {
            return null;
        }
        if (str.indexOf(38) < 0 && str.indexOf(60) < 0 && str.indexOf(62) < 0) {
            return str;
        }
        str = str.replaceAll("&amp;", "&");
        str = str.replaceAll("&lt;", "<");
        str = str.replaceAll("&gt;", ">");
        str = str.replaceAll("&", "&amp;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(">", "&gt;");
        return str;
    }

    public static String toEventName(int eventType) {
        String[] types = EVENT_TYPES;
        if (eventType < 0 || eventType >= types.length) {
            return String.valueOf(eventType);
        }
        return types[eventType];
    }
}

