/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLNode;
import com.reandroid.xml.XMLNodeTree;
import com.reandroid.xml.XMLUtil;
import com.reandroid.xml.base.Text;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XMLText
extends XMLNode
implements Text {
    private String text;

    public XMLText(String text) {
        this.text = text;
    }

    public XMLText() {
        this(null);
    }

    @Override
    public XMLElement getParentNode() {
        return (XMLElement)super.getParentNode();
    }

    @Override
    XMLNode newCopy(XMLNode parent) {
        XMLText xmlText;
        if (parent instanceof XMLNodeTree) {
            XMLNodeTree nodeTree = (XMLNodeTree)parent;
            xmlText = nodeTree.newText();
            xmlText.setText(this.text);
            nodeTree.add(xmlText);
        } else {
            xmlText = new XMLText(this.text);
        }
        return xmlText;
    }

    @Override
    public String getText() {
        return this.getText(false);
    }

    public String getText(boolean escapeXmlChars) {
        if (escapeXmlChars) {
            return XMLUtil.escapeXmlChars(this.text);
        }
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    public void appendText(char ch) {
        if (ch == '\u0000') {
            return;
        }
        this.appendText(String.valueOf(ch));
    }

    public void appendText(String text) {
        if (text == null) {
            return;
        }
        if (this.text == null || this.text.length() == 0) {
            this.text = text;
            return;
        }
        this.text = this.text + text;
    }

    private void appendEntityRef(String entityRef) {
        String decode;
        if (entityRef == null) {
            return;
        }
        if (entityRef.equals("lt")) {
            decode = "<";
        } else if (entityRef.equals("gt")) {
            decode = ">";
        } else if (entityRef.equals("amp")) {
            decode = "&";
        } else if (entityRef.equals("quote")) {
            decode = "\"";
        } else {
            return;
        }
        this.appendText(decode);
    }

    @Override
    public void serialize(XmlSerializer serializer) throws IOException {
        serializer.text(this.getText());
    }

    @Override
    public void parse(XmlPullParser parser) throws XmlPullParserException, IOException {
        int event = parser.getEventType();
        if (!XMLText.isTextEvent(event)) {
            throw new XmlPullParserException("Not text event");
        }
        while (XMLText.isTextEvent(event)) {
            if (event == 4) {
                this.appendText(parser.getText());
            } else if (event == 6) {
                this.appendEntityRef(parser.getName());
            }
            event = parser.next();
        }
    }

    @Override
    void write(Appendable appendable, boolean xml, boolean escapeXmlText) throws IOException {
        String text = this.getText(escapeXmlText);
        if (text != null) {
            appendable.append(text);
        }
    }

    @Override
    int appendDebugText(Appendable appendable, int limit, int length) throws IOException {
        if (length >= limit) {
            return length;
        }
        String text = this.getText();
        if (text != null) {
            appendable.append(text);
            length += text.length();
        }
        return length;
    }

    boolean isIndent() {
        return XMLText.isIndentText(this.getText());
    }

    static boolean isTextEvent(int event) {
        return event == 4 || event == 6;
    }

    private static boolean isIndentText(String text) {
        if (text == null || text.length() == 0) {
            return true;
        }
        if (text.charAt(0) != '\n') {
            return false;
        }
        char[] chars = text.toCharArray();
        for (int i = 1; i < chars.length; ++i) {
            if (chars[i] == ' ' || chars[i] == '\n') continue;
            return false;
        }
        return true;
    }
}

