/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.IndexIterator;
import com.reandroid.utils.collection.RecursiveIterator;
import com.reandroid.utils.collection.SizedSupplier;
import com.reandroid.xml.XMLAttribute;
import com.reandroid.xml.XMLComment;
import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLNamespace;
import com.reandroid.xml.XMLNode;
import com.reandroid.xml.XMLText;
import com.reandroid.xml.base.NodeTree;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Predicate;
import org.xmlpull.v1.XmlSerializer;

public abstract class XMLNodeTree
extends XMLNode
implements NodeTree<XMLNode>,
Iterable<XMLNode>,
SizedSupplier<XMLNode> {
    private ArrayCollection<XMLNode> mChildes = EMPTY;
    private int lastTrimSize;
    private static final int TRIM_INTERVAL = 1000;
    private static final ArrayCollection<XMLNode> EMPTY = ArrayCollection.empty();

    public XMLNode getLast() {
        int size = this.size();
        if (size == 0) {
            return null;
        }
        return this.mChildes.get(size - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.size() == 0) {
            return;
        }
        XMLNodeTree xMLNodeTree = this;
        synchronized (xMLNodeTree) {
            this.mChildes.clear();
            this.mChildes.trimToSize();
            this.lastTrimSize = 0;
        }
    }

    @Override
    public Iterator<XMLNode> iterator(Predicate<? super XMLNode> filter) {
        return new IndexIterator<XMLNode>(this, filter);
    }

    @Override
    public Iterator<XMLNode> iterator() {
        return new IndexIterator<XMLNode>(this);
    }

    public Iterator<XMLNode> recursiveNodes() {
        return RecursiveIterator.of(this, XMLNode::iterator);
    }

    @Override
    public int size() {
        return this.mChildes.size();
    }

    @Override
    public XMLNode get(int index) {
        return this.mChildes.get(index);
    }

    public void addAll(Iterable<? extends XMLNode> iterable) {
        Iterator<? extends XMLNode> itr = iterable.iterator();
        while (itr.hasNext()) {
            this.add(itr.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(XMLNode xmlNode) {
        if (xmlNode == null || xmlNode == this) {
            return false;
        }
        XMLNodeTree xMLNodeTree = this;
        synchronized (xMLNodeTree) {
            if (this.mChildes == EMPTY) {
                this.mChildes = new ArrayCollection();
            }
            boolean added = this.mChildes.add(xmlNode);
            xmlNode.setParentNode(this);
            if (this.mChildes.size() - this.lastTrimSize > 1000) {
                this.mChildes.trimToSize();
                this.lastTrimSize = this.mChildes.size();
            }
            return added;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int i, XMLNode xmlNode) {
        if (xmlNode == null || xmlNode == this) {
            return;
        }
        XMLNodeTree xMLNodeTree = this;
        synchronized (xMLNodeTree) {
            if (this.mChildes == EMPTY) {
                this.mChildes = new ArrayCollection();
            }
            this.mChildes.add(i, xmlNode);
            xmlNode.setParentNode(this);
            if (this.mChildes.size() - this.lastTrimSize > 1000) {
                this.mChildes.trimToSize();
                this.lastTrimSize = this.mChildes.size();
            }
        }
    }

    public int indexOf(XMLNode node) {
        return this.mChildes.indexOf(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(XMLNode xmlNode) {
        XMLNodeTree xMLNodeTree = this;
        synchronized (xMLNodeTree) {
            if (xmlNode != null && this.mChildes.remove(xmlNode)) {
                xmlNode.setParentNode(null);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XMLNode remove(int i) {
        XMLNodeTree xMLNodeTree = this;
        synchronized (xMLNodeTree) {
            XMLNode xmlNode = this.mChildes.remove(i);
            if (xmlNode != null) {
                xmlNode.setParentNode(null);
            }
            return xmlNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Predicate<? extends XMLNode> filter) {
        XMLNodeTree xMLNodeTree = this;
        synchronized (xMLNodeTree) {
            return this.mChildes.remove(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sort(Comparator<? super XMLNode> comparator) {
        XMLNodeTree xMLNodeTree = this;
        synchronized (xMLNodeTree) {
            return this.mChildes.sortItems(comparator);
        }
    }

    @Override
    public void serialize(XmlSerializer serializer) throws IOException {
        this.startSerialize(serializer);
        this.serializeChildes(serializer);
        this.endSerialize(serializer);
    }

    abstract void startSerialize(XmlSerializer var1) throws IOException;

    private void serializeChildes(XmlSerializer serializer) throws IOException {
        Iterator<XMLNode> itr = this.iterator();
        while (itr.hasNext()) {
            itr.next().serialize(serializer);
        }
    }

    abstract void endSerialize(XmlSerializer var1) throws IOException;

    public XMLElement newElement() {
        return new XMLElement();
    }

    public XMLText newText() {
        return new XMLText();
    }

    public XMLComment newComment() {
        return new XMLComment();
    }

    public XMLAttribute newAttribute() {
        return new XMLAttribute();
    }

    public XMLNamespace newNamespace(String uri, String prefix) {
        return new XMLNamespace(uri, prefix);
    }
}

