/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLFactory;
import com.reandroid.xml.XMLNode;
import com.reandroid.xml.XMLNodeTree;
import com.reandroid.xml.XMLText;
import com.reandroid.xml.XMLUtil;
import com.reandroid.xml.base.Document;
import com.reandroid.xml.base.Element;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XMLDocument
extends XMLNodeTree
implements Document<XMLElement> {
    private String encoding;
    private Boolean standalone;

    public XMLDocument(String elementName) {
        this();
        XMLElement docElem = new XMLElement(elementName);
        this.setDocumentElement(docElem);
    }

    public XMLDocument() {
    }

    @Override
    XMLDocument newCopy(XMLNode parent) {
        XMLDocument document = new XMLDocument();
        document.encoding = this.encoding;
        document.standalone = this.standalone;
        Iterator<XMLNode> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next().newCopy(document);
        }
        return document;
    }

    @Override
    public XMLElement getDocumentElement() {
        return CollectionUtil.getFirst(this.iterator(XMLElement.class));
    }

    @Override
    public void setDocumentElement(XMLElement element) {
        this.clear();
        this.add(element);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setStandalone(Boolean standalone) {
        this.standalone = standalone;
    }

    @Override
    public void parse(XmlPullParser parser) throws XmlPullParserException, IOException {
        this.encoding = null;
        this.standalone = null;
        this.clear();
        int event = parser.getEventType();
        if (event == 0) {
            this.encoding = parser.getInputEncoding();
            XMLUtil.ensureStartTag(parser);
        } else if (event == 3 || event == 2) {
            parser.next();
        } else if (event == 1) {
            return;
        }
        XMLUtil.ensureStartTag(parser);
        Element element = this.newElement();
        this.add((XMLNode)((Object)element));
        ((XMLElement)element).parse(parser);
    }

    public void parseInner(XmlPullParser parser) throws XmlPullParserException, IOException {
        this.encoding = null;
        this.standalone = null;
        this.clear();
        int event = parser.getEventType();
        if (event == 0) {
            this.encoding = parser.getInputEncoding();
            event = XMLUtil.ensureStartTag(parser);
        }
        if (event == 1) {
            return;
        }
        if (event != 2) {
            throw new XmlPullParserException("Invalid document event: " + event);
        }
        parser.next();
        this.parseAll(parser);
    }

    private void parseAll(XmlPullParser parser) throws XmlPullParserException, IOException {
        int event = parser.getEventType();
        while (event != 3 && event != 1) {
            XMLNode node = this.createChildNode(event);
            if (node != null) {
                this.add(node);
                node.parse(parser);
                event = parser.getEventType();
                continue;
            }
            event = parser.nextToken();
        }
    }

    @Override
    void startSerialize(XmlSerializer serializer) throws IOException {
        if (this.encoding == null) {
            return;
        }
        serializer.startDocument(this.encoding, this.standalone);
    }

    @Override
    void endSerialize(XmlSerializer serializer) {
        if (this.encoding == null) {
            return;
        }
        try {
            serializer.endDocument();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    void appendDocument(Appendable appendable, boolean xml) throws IOException {
        if (this.encoding == null || !xml) {
            return;
        }
        appendable.append("<?xml version='1.0' encoding='");
        appendable.append(this.encoding);
        appendable.append("'?>");
    }

    @Override
    void write(Appendable appendable, boolean xml, boolean escapeXmlText) throws IOException {
        this.appendDocument(appendable, xml);
        this.getDocumentElement().write(appendable, xml, escapeXmlText);
    }

    @Override
    int appendDebugText(Appendable appendable, int limit, int length) throws IOException {
        if (length > limit) {
            return length;
        }
        Iterator<XMLNode> iterator = this.iterator();
        while (iterator.hasNext() && length < limit) {
            length = iterator.next().appendDebugText(appendable, limit, length);
        }
        return length;
    }

    public static XMLDocument load(String text) throws XmlPullParserException, IOException {
        XMLDocument document = new XMLDocument();
        document.parse(XMLFactory.newPullParser(text));
        return document;
    }

    public static XMLDocument load(InputStream inputStream) throws XmlPullParserException, IOException {
        XMLDocument document = new XMLDocument();
        document.parse(XMLFactory.newPullParser(inputStream));
        return document;
    }

    public static XMLDocument load(File file) throws XmlPullParserException, IOException {
        XMLDocument document = new XMLDocument();
        document.parse(XMLFactory.newPullParser(file));
        return document;
    }

    XMLNode createChildNode(int event) {
        if (event == 2) {
            return this.newElement();
        }
        if (XMLText.isTextEvent(event)) {
            return this.newText();
        }
        return null;
    }
}

