/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.common.Namespace;
import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLNamespace;
import com.reandroid.xml.XMLNode;
import com.reandroid.xml.XMLUtil;
import com.reandroid.xml.base.Attribute;
import java.io.IOException;
import java.util.Objects;
import org.xmlpull.v1.XmlSerializer;

public class XMLAttribute
extends XMLNode
implements Attribute {
    private String mName;
    private String mValue;
    private XMLNamespace mNamespace;

    public XMLAttribute() {
    }

    public XMLAttribute(String name, String value) {
        this();
        this.mName = name;
        this.mValue = value;
    }

    @Override
    XMLAttribute newCopy(XMLNode parent) {
        XMLAttribute attribute = new XMLAttribute();
        attribute.setParentNode(parent);
        attribute.setName(this.getUri(), this.getPrefix(), this.getName(false));
        if (parent instanceof XMLElement) {
            ((XMLElement)parent).addAttribute(attribute);
        }
        return attribute;
    }

    @Override
    public XMLElement getParentNode() {
        return (XMLElement)super.getParentNode();
    }

    public boolean equalsName(String name) {
        if (name == null) {
            return this.getName() == null;
        }
        String prefix = XMLUtil.splitPrefix(name);
        if (prefix != null && !prefix.equals(this.getPrefix())) {
            return false;
        }
        return name.equals(this.getName());
    }

    @Override
    public String getName() {
        return this.getName(false);
    }

    @Override
    public String getName(boolean includePrefix) {
        String name = this.mName;
        if (!includePrefix || name == null) {
            return name;
        }
        String prefix = this.getPrefix();
        if (prefix != null) {
            name = prefix + ":" + name;
        }
        return name;
    }

    @Override
    public XMLNamespace getNamespace() {
        return this.mNamespace;
    }

    @Override
    public void setNamespace(Namespace namespace) {
        this.mNamespace = (XMLNamespace)namespace;
    }

    public void setNamespace(String uri, String prefix) {
        XMLElement element = this.getParentNode();
        if (element == null) {
            throw new IllegalArgumentException("Parent element is null");
        }
        this.setNamespace(element.getOrCreateXMLNamespace(uri, prefix));
    }

    @Override
    public String getPrefix() {
        XMLNamespace namespace = this.getNamespace();
        if (namespace != null) {
            return namespace.getPrefix();
        }
        String name = this.mName;
        int i = name.indexOf(58);
        if (i > 0) {
            return name.substring(0, i);
        }
        return null;
    }

    @Override
    public String getValueAsString() {
        return this.getValueAsString(false);
    }

    public String getValueAsString(boolean escapeXmlText) {
        String value = this.mValue;
        if (value == null) {
            this.mValue = value = "";
        }
        if (escapeXmlText) {
            return XMLUtil.escapeXmlChars(value);
        }
        return value;
    }

    XMLAttribute set(String name, String value) {
        this.mName = name;
        this.mValue = value;
        return this;
    }

    @Override
    public void setName(String name) {
        this.setName(null, null, name);
    }

    public void setName(String uri, String name) {
        this.setName(uri, null, name);
    }

    public void setName(String uri, String prefix, String name) {
        XMLElement element;
        this.mName = XMLUtil.splitName(name);
        if (XMLUtil.isEmpty(prefix)) {
            prefix = XMLUtil.splitPrefix(name);
        }
        if (XMLUtil.isEmpty(uri)) {
            uri = null;
        }
        if ((element = this.getParentNode()) == null) {
            throw new IllegalArgumentException("Parent element is null");
        }
        XMLNamespace namespace = null;
        if (uri != null && prefix != null) {
            namespace = element.getOrCreateXMLNamespace(uri, prefix);
        } else if (uri != null) {
            namespace = element.getXMLNamespaceByUri(uri);
            if (namespace == null) {
                throw new IllegalArgumentException("Namespace not found for uri: " + uri);
            }
        } else if (prefix != null && (namespace = element.getXMLNamespaceByPrefix(prefix)) == null) {
            throw new IllegalArgumentException("Namespace not found for prefix: " + prefix);
        }
        if (namespace != null) {
            this.setNamespace(namespace);
        }
        this.mName = name;
    }

    public void setValue(String value) {
        this.mValue = value;
    }

    public void setPrefix(String prefix) {
        if (Objects.equals(prefix, this.getPrefix())) {
            return;
        }
        XMLElement element = this.getParentNode();
        if (element == null) {
            throw new IllegalArgumentException("Parent element is null");
        }
        this.setNamespace(element.getXMLNamespaceByPrefix(prefix));
    }

    @Override
    public void serialize(XmlSerializer serializer) throws IOException {
        serializer.attribute(this.getUri(), this.getName(), this.getValueAsString(false));
    }

    @Override
    void write(Appendable appendable, boolean xml, boolean escapeXmlText) throws IOException {
        appendable.append(this.getName(true));
        appendable.append('=');
        if (xml) {
            appendable.append('\"');
        }
        appendable.append(this.getValueAsString(escapeXmlText));
        if (xml) {
            appendable.append('\"');
        }
    }

    @Override
    int appendDebugText(Appendable appendable, int limit, int length) throws IOException {
        if (length >= limit) {
            return length;
        }
        String name = this.getName(true);
        if (name == null) {
            name = "null";
        }
        appendable.append(name);
        length += name.length();
        appendable.append('=');
        appendable.append('\"');
        String value = XMLUtil.escapeXmlChars(this.getValueAsString());
        if (value == null) {
            value = "null";
        }
        appendable.append(value);
        appendable.append('\"');
        return length += value.length() + 3;
    }

    public int hashCode() {
        String name = this.getName(false);
        if (name == null) {
            name = "";
        }
        return name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof XMLAttribute) {
            XMLAttribute attribute = (XMLAttribute)obj;
            return Objects.equals(this.getName(false), attribute.getName(false));
        }
        return false;
    }
}

