/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.xml.Span;
import com.reandroid.xml.StyleAttribute;
import com.reandroid.xml.StyleElement;
import java.io.IOException;
import java.util.Iterator;
import org.xmlpull.v1.XmlSerializer;

public class StyleSpanEvent
implements Comparable<StyleSpanEvent> {
    private final int type;
    private final char mChar;
    private final Span span;
    public static final int TYPE_START_END = ObjectsUtil.of(0);
    public static final int TYPE_START_TAG = ObjectsUtil.of(1);
    public static final int TYPE_CHAR = ObjectsUtil.of(2);
    public static final int TYPE_END_TAG = ObjectsUtil.of(3);

    public StyleSpanEvent(int type, char ch, Span span) {
        this.type = type;
        this.mChar = ch;
        this.span = span;
    }

    public StyleSpanEvent(char ch) {
        this(TYPE_CHAR, ch, null);
    }

    public StyleSpanEvent(int type, Span span) {
        this(type, '\u0000', span);
    }

    public int getType() {
        return this.type;
    }

    public char getChar() {
        return this.mChar;
    }

    public Span getSpan() {
        return this.span;
    }

    public void serialize(XmlSerializer serializer) throws IOException {
        int type = this.getType();
        if (type == TYPE_CHAR) {
            serializer.text(String.valueOf(this.getChar()));
        } else if (type == TYPE_START_END) {
            Span span = this.getSpan();
            StyleElement element = span.toElement();
            String name = element.getName();
            serializer.startTag(null, name);
            Iterator<StyleAttribute> iterator = element.getAttributes();
            while (iterator.hasNext()) {
                StyleAttribute attribute = iterator.next();
                attribute.serialize(serializer);
            }
            serializer.endTag(null, name);
        } else if (type == TYPE_START_TAG) {
            Span span = this.getSpan();
            StyleElement element = span.toElement();
            serializer.startTag(null, element.getName());
            Iterator<StyleAttribute> iterator = element.getAttributes();
            while (iterator.hasNext()) {
                StyleAttribute attribute = iterator.next();
                attribute.serialize(serializer);
            }
        } else if (type == TYPE_END_TAG) {
            Span span = this.getSpan();
            serializer.endTag(null, span.getTagName());
        } else {
            throw new IOException("Unknown span event: " + type);
        }
    }

    @Override
    public int compareTo(StyleSpanEvent event) {
        if (event == this) {
            return 0;
        }
        int type1 = this.getType();
        int type2 = event.getType();
        int j = CompareUtil.compare(type1, type2);
        if (type1 == TYPE_CHAR || type2 == TYPE_CHAR) {
            return j;
        }
        int i = CompareUtil.compare(this.getSpan().getSpanOrder(), event.getSpan().getSpanOrder());
        if (type1 == TYPE_START_END) {
            if (type2 == TYPE_END_TAG) {
                return 1;
            }
            return i;
        }
        if (type2 == TYPE_START_END) {
            if (type1 == TYPE_END_TAG) {
                return 1;
            }
            return i;
        }
        if (i == 0) {
            return j;
        }
        if (j == 0 && type1 == TYPE_END_TAG) {
            i = -i;
        }
        return i;
    }

    public int compareTo1(StyleSpanEvent event) {
        if (event == this) {
            return 0;
        }
        int type1 = this.getType();
        int type2 = event.getType();
        if (type1 == TYPE_CHAR) {
            if (type2 == TYPE_START_TAG || type2 == TYPE_START_END) {
                return 1;
            }
            return -1;
        }
        if (type2 == TYPE_CHAR) {
            if (type1 == TYPE_START_TAG || type1 == TYPE_START_END) {
                return -1;
            }
            return 1;
        }
        int i = CompareUtil.compare(this.getSpan().getSpanOrder(), event.getSpan().getSpanOrder());
        int j = CompareUtil.compare(type1, type2);
        if (type1 == TYPE_START_END) {
            if (type2 == TYPE_END_TAG) {
                return 1;
            }
            return i;
        }
        if (type2 == TYPE_START_END) {
            if (type1 == TYPE_END_TAG) {
                return 1;
            }
            return i;
        }
        if (i == 0) {
            return j;
        }
        if (j == 0 && type1 == TYPE_END_TAG) {
            i = -i;
        }
        return i;
    }

    public String toString() {
        int type = this.getType();
        if (type == TYPE_CHAR) {
            return String.valueOf(this.getChar());
        }
        if (type == TYPE_START_TAG) {
            return "<" + this.getSpan().getTagName() + ">";
        }
        if (type == TYPE_START_END) {
            return "<" + this.getSpan().getTagName() + "/>";
        }
        return "</" + this.getSpan().getTagName() + ">";
    }
}

