/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.utils.collection.InstanceIterator;
import com.reandroid.utils.io.IOUtil;
import com.reandroid.xml.SpanSet;
import com.reandroid.xml.StyleAttribute;
import com.reandroid.xml.StyleElement;
import com.reandroid.xml.StyleNode;
import com.reandroid.xml.StyleText;
import com.reandroid.xml.XMLComment;
import com.reandroid.xml.XMLDocument;
import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLFactory;
import com.reandroid.xml.XMLNode;
import com.reandroid.xml.XMLText;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class StyleDocument
extends XMLDocument
implements SpanSet<StyleElement>,
StyleNode,
Comparable<StyleDocument> {
    private static final XmlPullParser PARSER = XMLFactory.newPullParser();

    public boolean hasElements() {
        return this.getElements().hasNext();
    }

    public Iterator<StyleElement> getElements() {
        return this.iterator(StyleElement.class);
    }

    @Override
    public Iterator<StyleElement> getSpans() {
        return InstanceIterator.of(this.recursiveNodes(), StyleElement.class);
    }

    public Iterator<StyleText> getStyleTexts() {
        return InstanceIterator.of(this.recursiveNodes(), StyleText.class);
    }

    @Override
    public void appendChar(char ch) {
        StyleText styleText;
        if (ch == '\u0000') {
            return;
        }
        XMLNode xmlNode = this.getLast();
        if (xmlNode instanceof StyleText) {
            styleText = (StyleText)xmlNode;
        } else {
            styleText = new StyleText();
            this.add(styleText);
        }
        styleText.appendChar(ch);
    }

    @Override
    public StyleNode getParentStyle() {
        return null;
    }

    @Override
    public void addStyleNode(StyleNode styleNode) {
        this.add((XMLNode)((Object)styleNode));
    }

    public String getXml() {
        return this.toText(true, false);
    }

    public String getXml(boolean escapeXmlText) {
        return this.toText(true, escapeXmlText);
    }

    public String getHtml() {
        return this.getText(false, false);
    }

    public String getText(boolean xml, boolean escapeXmlText) {
        return this.toText(xml, escapeXmlText);
    }

    public String getStyledString() {
        StringWriter writer = new StringWriter();
        try {
            this.writeStyledText(writer);
            writer.flush();
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    void writeStyledText(Appendable appendable) throws IOException {
        for (XMLNode xmlNode : this) {
            if (xmlNode instanceof StyleText) {
                StyleText styleText = (StyleText)xmlNode;
                styleText.writeStyledText(appendable);
                continue;
            }
            if (!(xmlNode instanceof StyleElement)) continue;
            StyleElement element = (StyleElement)xmlNode;
            element.writeStyledText(appendable);
        }
    }

    public void parseString(String xmlString) throws XmlPullParserException, IOException {
        xmlString = "<parser>" + xmlString + "</parser>";
        XmlPullParser parser = PARSER;
        parser.setInput(new StringReader(xmlString));
        this.parseInner(parser);
        IOUtil.close(parser);
    }

    @Override
    void write(Appendable appendable, boolean xml, boolean escapeXmlText) throws IOException {
        this.appendDocument(appendable, xml);
        this.appendChildes(this.iterator(), appendable, xml, escapeXmlText);
    }

    private void appendChildes(Iterator<XMLNode> iterator, Appendable appendable, boolean xml, boolean escapeXmlText) throws IOException {
        while (iterator.hasNext()) {
            iterator.next().write(appendable, xml, escapeXmlText);
        }
    }

    @Override
    public int compareTo(StyleDocument document) {
        if (document == null) {
            return 0;
        }
        return this.getStyledString().compareTo(document.getStyledString());
    }

    public int hashCode() {
        return this.getXml().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StyleDocument)) {
            return false;
        }
        return this.getXml().equals(((StyleDocument)obj).getXml());
    }

    @Override
    public StyleElement newElement() {
        return new StyleElement();
    }

    @Override
    public StyleText newText() {
        return new StyleText();
    }

    @Override
    public XMLComment newComment() {
        return null;
    }

    @Override
    public StyleAttribute newAttribute() {
        return new StyleAttribute();
    }

    public static StyleDocument parseNext(XmlPullParser parser) throws IOException, XmlPullParserException {
        StyleDocument styleDocument = new StyleDocument();
        styleDocument.parseInner(parser);
        return styleDocument;
    }

    public static StyleDocument copyInner(XMLElement xmlElement) {
        StyleDocument styleDocument = new StyleDocument();
        for (XMLNode xmlNode : xmlElement) {
            if (xmlNode instanceof XMLElement) {
                StyleElement styleElement = new StyleElement();
                styleDocument.add(styleElement);
                styleElement.copyFrom((XMLElement)xmlNode);
                continue;
            }
            if (!(xmlNode instanceof XMLText)) continue;
            XMLText xmlText = (XMLText)xmlNode;
            StyleText styleText = new StyleText(xmlText.getText());
            styleDocument.add(styleText);
        }
        return styleDocument;
    }

    public static StyleDocument parseStyledString(String xmlStyledString) throws XmlPullParserException, IOException {
        StyleDocument styleDocument = new StyleDocument();
        styleDocument.parseString(xmlStyledString);
        return styleDocument;
    }
}

