/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.EmptyList;
import com.reandroid.xml.StyleAttribute;
import com.reandroid.xml.StyleElement;
import com.reandroid.xml.XMLAttribute;
import java.util.List;

public interface Span {
    public String getTagName();

    public int getFirstChar();

    public int getLastChar();

    public int getSpanOrder();

    public String getSpanAttributes();

    default public StyleElement toElement() {
        StyleElement element = new StyleElement(this.getTagName());
        element.addAttributes(this.parseAttributes(this.getSpanAttributes()));
        return element;
    }

    default public List<StyleAttribute> parseAttributes(String attributes) {
        if (attributes == null || attributes.length() == 0) {
            return EmptyList.of();
        }
        ArrayCollection<StyleAttribute> results = new ArrayCollection<StyleAttribute>();
        XMLAttribute attribute = null;
        StringBuilder builder = new StringBuilder();
        int length = attributes.length();
        boolean quoted = false;
        for (int i = 0; i < length; ++i) {
            char ch = attributes.charAt(i);
            if (ch == '=' && attribute == null) {
                if (builder != null) {
                    attribute = new StyleAttribute(builder.toString(), "");
                    results.add(attribute);
                }
                builder = null;
                quoted = false;
                continue;
            }
            if (ch == '\"' && attribute != null) {
                if (quoted) {
                    attribute.setValue(builder.toString());
                    attribute = null;
                    builder = null;
                    continue;
                }
                if (builder == null) {
                    quoted = true;
                    builder = new StringBuilder();
                    continue;
                }
                builder.append(ch);
                continue;
            }
            if (ch == ' ' || ch == ';') {
                if (attribute == null || builder == null) {
                    attribute = null;
                    builder = null;
                    quoted = false;
                    continue;
                }
                if (quoted) {
                    builder.append(ch);
                    continue;
                }
                attribute.setValue(builder.toString());
                attribute = null;
                builder = null;
                continue;
            }
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(ch);
        }
        if (attribute != null && builder != null) {
            attribute.setValue(builder.toString());
        }
        return results;
    }

    public static String splitTagName(String raw) {
        if (raw == null) {
            return null;
        }
        int i = raw.indexOf(59);
        if (i < 0) {
            i = raw.indexOf(32);
        }
        if (i < 0) {
            return raw;
        }
        return raw.substring(0, i);
    }

    public static String splitAttribute(String tagWithAttribute) {
        if (tagWithAttribute == null || tagWithAttribute.length() == 0) {
            return "";
        }
        if (tagWithAttribute.charAt(0) == ' ') {
            tagWithAttribute = tagWithAttribute.trim();
        }
        int i = tagWithAttribute.indexOf(59);
        int i2 = tagWithAttribute.indexOf(32);
        if (i < 0) {
            i = i2;
        } else if (i2 >= 0 && i2 < i) {
            i = i2;
        }
        if (i < 0) {
            return "";
        }
        return tagWithAttribute.substring(i + 1);
    }
}

