/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils.io;

import com.reandroid.utils.io.FileUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class IOUtil {
    public static String readUtf8(File file) throws IOException {
        return new String(IOUtil.readFully(file), StandardCharsets.UTF_8);
    }

    public static String readUtf8(InputStream inputStream) throws IOException {
        return new String(IOUtil.readFully(inputStream), StandardCharsets.UTF_8);
    }

    public static void writeUtf8(String content, File file) throws IOException {
        IOUtil.writeUtf8(content, FileUtil.outputStream(file));
    }

    public static void writeUtf8(String content, OutputStream outputStream) throws IOException {
        byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
        outputStream.write(bytes, 0, bytes.length);
        outputStream.close();
    }

    public static void writeAll(InputStream inputStream, File file) throws IOException {
        FileUtil.ensureParentDirectory(file);
        File tmp = file;
        if (tmp.isFile()) {
            tmp = FileUtil.toTmpName(tmp);
        }
        IOUtil.writeAll(inputStream, FileUtil.outputStream(tmp), true);
        if (!tmp.equals(file)) {
            file.delete();
            tmp.renameTo(tmp);
        }
    }

    public static void writeAll(InputStream inputStream, OutputStream outputStream) throws IOException {
        IOUtil.writeAll(inputStream, outputStream, true);
    }

    public static void writeAll(InputStream inputStream, OutputStream outputStream, boolean close) throws IOException {
        int read;
        int bufferStep;
        int bufferLength = bufferStep = 1024000;
        int maxBuffer = bufferLength * 10;
        byte[] buffer = new byte[bufferLength];
        while ((read = inputStream.read(buffer, 0, buffer.length)) >= 0) {
            outputStream.write(buffer, 0, read);
            bufferLength = buffer.length;
            if (read != bufferLength || bufferLength >= maxBuffer) continue;
            buffer = new byte[bufferLength += bufferStep];
        }
        if (close) {
            inputStream.close();
            outputStream.close();
        }
    }

    public static byte[] readFully(File file) throws IOException {
        return IOUtil.readFully(FileUtil.inputStream(file));
    }

    public static byte[] readFully(InputStream inputStream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        IOUtil.writeAll(inputStream, outputStream, true);
        return outputStream.toByteArray();
    }

    @Deprecated
    public static String shortPath(File file, int depth) {
        return FileUtil.shortPath(file, depth);
    }

    public static void close(Object obj) throws IOException {
        if (obj instanceof Closeable) {
            ((Closeable)obj).close();
        }
    }
}

