/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils.io;

import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.ArraySort;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.io.FileUtil;
import java.io.File;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Predicate;

public class FileIterator
implements Iterator<File> {
    private final File file;
    private final Predicate<File> filter;
    private final Comparator<File> comparator;
    private final File[] files;
    private int index;
    private File currentFile;
    private FileIterator currentIterator;
    public static final Comparator<File> NAME_COMPARATOR = (file1, file2) -> {
        boolean is_file1 = file1.isFile();
        boolean is_file2 = file2.isFile();
        if (is_file1 && !is_file2) {
            return -1;
        }
        if (!is_file1 && is_file2) {
            return 1;
        }
        return StringsUtil.toUpperCase(file1.getName()).compareTo(StringsUtil.toUpperCase(file2.getName()));
    };

    public FileIterator(File file, Predicate<File> filter, Comparator<File> comparator) {
        Object[] files;
        this.file = file;
        this.filter = filter;
        this.comparator = comparator;
        if (file.isDirectory()) {
            files = file.listFiles();
            if (files != null && comparator != null) {
                ArraySort.sort(files, comparator);
            }
        } else {
            files = null;
        }
        this.files = files;
        this.index = -2;
    }

    public FileIterator(File file, Predicate<File> filter) {
        this(file, filter, null);
    }

    public FileIterator(File file, Comparator<File> comparator) {
        this(file, null, comparator);
    }

    public FileIterator(File file) {
        this(file, null, null);
    }

    @Override
    public boolean hasNext() {
        return this.getCurrent() != null;
    }

    @Override
    public File next() {
        File currentFile = this.getCurrent();
        this.currentFile = null;
        return currentFile;
    }

    private File getCurrent() {
        File currentFile = this.currentFile;
        if (currentFile == null) {
            this.currentFile = currentFile = this.computeNext();
        }
        return currentFile;
    }

    private File computeNext() {
        FileIterator fileIterator;
        if (this.index == -2) {
            this.index = -1;
            File file = this.file;
            if (this.matchesFile(file)) {
                return file;
            }
        }
        if ((fileIterator = this.getCurrentIterator()) != null && fileIterator.hasNext()) {
            return fileIterator.next();
        }
        return null;
    }

    private FileIterator getCurrentIterator() {
        int i;
        FileIterator currentIterator = this.currentIterator;
        if (currentIterator != null && currentIterator.hasNext()) {
            return currentIterator;
        }
        ++this.index;
        File[] files = this.files;
        if (files == null || this.index >= files.length) {
            this.currentIterator = null;
            return null;
        }
        int length = files.length;
        for (i = this.index; i < length; ++i) {
            currentIterator = new FileIterator(files[i], this.filter, this.comparator);
            files[i] = null;
            if (currentIterator.hasNext()) break;
            currentIterator = null;
        }
        this.index = i;
        this.currentIterator = currentIterator;
        return currentIterator;
    }

    private boolean matchesFile(File file) {
        if (!file.isFile()) {
            return false;
        }
        return this.filter == null || this.filter.test(file);
    }

    public static Predicate<File> getExtensionFilter(String extension) {
        if (extension == null) {
            return CollectionUtil.getAcceptAll();
        }
        return file -> extension.equalsIgnoreCase(FileUtil.getExtension(file));
    }
}

