/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils.collection;

import com.reandroid.utils.collection.FilterIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;

public class UniqueIterator<T>
extends FilterIterator<T> {
    private Set<T> excludeSet;

    public UniqueIterator(Iterator<T> iterator, Predicate<? super T> filter) {
        super(iterator, filter);
    }

    public UniqueIterator(Iterator<T> iterator) {
        super(iterator);
    }

    public T exclude(T item) {
        if (item == null) {
            return null;
        }
        Set<T> excludeSet = this.excludeSet;
        if (excludeSet == null) {
            excludeSet = new HashSet<T>();
            this.excludeSet = excludeSet;
        }
        excludeSet.add(item);
        return item;
    }

    @Override
    public T next() {
        return this.exclude(super.next());
    }

    @Override
    public boolean test(T item) {
        if (item == null) {
            return false;
        }
        Set<T> excludeSet = this.excludeSet;
        return excludeSet == null || !excludeSet.contains(item);
    }
}

