/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils.collection;

import com.reandroid.utils.collection.IterableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;

public class RecursiveIterator<T>
implements Iterator<T> {
    private T item;
    private final Function<T, Iterator<? extends T>> function;
    private final Predicate<? super T> filter;
    private boolean firstProcessed;
    private T current;
    private Iterator<? extends T> currentIterator;
    private RecursiveIterator<T> currentRecursiveIterator;

    public RecursiveIterator(T item, Function<T, Iterator<? extends T>> function, Predicate<? super T> filter) {
        this.item = item;
        this.function = function;
        this.filter = filter;
    }

    public RecursiveIterator(T item, Function<T, Iterator<? extends T>> function) {
        this((T)item, (Function<? extends T, Iterator<? extends T>>)function, (Predicate<? extends T>)null);
    }

    @Override
    public boolean hasNext() {
        return this.getCurrent() != null;
    }

    @Override
    public T next() {
        T current = this.getCurrent();
        if (current == null) {
            throw new NoSuchElementException();
        }
        this.current = null;
        return current;
    }

    private T getCurrent() {
        T current = this.current;
        if (current == null) {
            this.current = current = this.computeCurrent();
        }
        return current;
    }

    private T computeCurrent() {
        Iterator<T> iterator;
        if (!this.firstProcessed) {
            this.firstProcessed = true;
            T element = this.item;
            if (this.matches(element)) {
                return element;
            }
            this.item = null;
            return null;
        }
        if (this.item != null) {
            this.initCurrentIterator();
        }
        if ((iterator = this.getCurrentIterator()) != null && iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    private Iterator<? extends T> getCurrentIterator() {
        Iterator<Object> iterator = this.currentRecursiveIterator;
        if (iterator != null && iterator.hasNext()) {
            return iterator;
        }
        this.currentRecursiveIterator = null;
        iterator = this.currentIterator;
        if (iterator != null && iterator.hasNext()) {
            this.currentRecursiveIterator = new RecursiveIterator<T>(iterator.next(), this.function, this.filter);
            iterator = this.currentRecursiveIterator;
        } else {
            iterator = null;
            this.currentIterator = null;
        }
        if (iterator != null && !iterator.hasNext()) {
            return this.getCurrentIterator();
        }
        return iterator;
    }

    private void initCurrentIterator() {
        T element = this.item;
        this.item = null;
        Iterator<T> iterator = element == null ? null : this.function.apply(element);
        this.currentIterator = iterator;
    }

    private boolean matches(T element) {
        if (element == null) {
            return false;
        }
        Predicate<T> filter = this.filter;
        return filter == null || filter.test(element);
    }

    public static <T1> Iterator<T1> of(T1 item, Function<T1, Iterator<? extends T1>> function, Predicate<? super T1> filter) {
        return new RecursiveIterator<T1>(item, function, filter);
    }

    public static <T1> Iterator<T1> of(T1 item, Function<T1, Iterator<? extends T1>> function) {
        return new RecursiveIterator<T1>(item, function);
    }

    public static <T1, E> Iterator<E> compute(T1 item, Function<T1, Iterator<? extends T1>> function, Function<T1, Iterator<? extends E>> computer) {
        return RecursiveIterator.compute(item, function, null, computer);
    }

    public static <T1, E> Iterator<E> compute(T1 item, Function<T1, Iterator<? extends T1>> function, Predicate<? super T1> filter, final Function<T1, Iterator<? extends E>> computer) {
        return new IterableIterator<T1, E>(new RecursiveIterator<T1>(item, function, filter)){

            @Override
            public Iterator<E> iterator(T1 element) {
                return (Iterator)computer.apply(element);
            }
        };
    }
}

