/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils.collection;

import com.reandroid.utils.collection.EmptyList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class ListItr<T>
implements ListIterator<T> {
    private final List<T> list;
    private int cursor;
    private int lastRet;
    private static ListItr<?> empty_itr;

    public ListItr(List<T> list, int start) {
        this.list = list;
        this.cursor = start;
        this.lastRet = -1;
    }

    public ListItr(List<T> list) {
        this(list, 0);
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.list.size();
    }

    @Override
    public T next() {
        int i;
        this.lastRet = i = this.cursor;
        this.cursor = i + 1;
        return this.list.get(i);
    }

    @Override
    public boolean hasPrevious() {
        return this.cursor != 0;
    }

    @Override
    public int nextIndex() {
        return this.cursor;
    }

    @Override
    public int previousIndex() {
        return this.cursor - 1;
    }

    @Override
    public void remove() {
        int i = this.lastRet;
        this.list.remove(i);
        this.cursor = i;
        this.lastRet = -1;
    }

    @Override
    public T previous() {
        int i = this.cursor - 1;
        if (i < 0) {
            throw new NoSuchElementException();
        }
        this.cursor = i;
        this.lastRet = i;
        return this.list.get(i);
    }

    @Override
    public void set(T item) {
        this.list.set(this.lastRet, item);
    }

    @Override
    public void add(T item) {
        int i = this.cursor;
        this.list.add(i, item);
        this.cursor = i + 1;
        this.lastRet = -1;
    }

    public static <T1> ListIterator<T1> empty() {
        ListItr<Object> empty = empty_itr;
        if (empty == null) {
            empty_itr = empty = new ListItr(EmptyList.of());
        }
        return empty;
    }

    public static <T1> ListIterator<T1> of(List<T1> list) {
        return ListItr.of(list, 0);
    }

    public static <T1> ListIterator<T1> of(List<T1> list, int start) {
        if (list.size() - start <= 0) {
            return ListItr.empty();
        }
        return new ListItr<T1>(list, start);
    }
}

