/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils.collection;

import com.reandroid.utils.collection.SingleIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CombiningIterator<T, E extends T>
implements Iterator<T> {
    private Iterator<? extends T> iterator1;
    private Iterator<? extends T> iterator2;
    private Iterator<? extends T> iterator3;
    private Iterator<? extends T> iterator4;
    private Iterator<Iterator<E>> iteratorIterator;
    private Iterator<? extends T> mCurrentIterator;
    private T mCurrentItem;

    public CombiningIterator(Iterator<? extends T> iterator1, Iterator<? extends T> iterator2, Iterator<? extends T> iterator3, Iterator<Iterator<E>> iteratorIterator) {
        this.iterator1 = iterator1;
        this.iterator2 = iterator2;
        this.iterator3 = iterator3;
        this.iteratorIterator = iteratorIterator;
    }

    public CombiningIterator(Iterator<? extends T> iterator1, Iterator<? extends T> iterator2, Iterator<? extends T> iterator3) {
        this(iterator1, iterator2, iterator3, null);
    }

    public CombiningIterator(Iterator<? extends T> iterator1, Iterator<? extends T> iterator2) {
        this(iterator1, iterator2, null, null);
    }

    public CombiningIterator(Iterator<? extends T> iterator1, Iterator<Iterator<E>> iteratorIterator, Void ignored) {
        this(iterator1, null, null, iteratorIterator);
    }

    public CombiningIterator(Iterator<Iterator<E>> iteratorIterator) {
        this(null, null, null, iteratorIterator);
    }

    @Override
    public boolean hasNext() {
        return this.getCurrentItem() != null;
    }

    @Override
    public T next() {
        T item = this.getCurrentItem();
        if (item == null) {
            throw new NoSuchElementException();
        }
        this.mCurrentItem = null;
        return item;
    }

    private T getCurrentItem() {
        T item = this.mCurrentItem;
        if (item == null) {
            this.mCurrentItem = item = this.readNext();
        }
        return item;
    }

    private T readNext() {
        T item;
        Iterator<T> iterator = this.iterator1;
        if (iterator != null) {
            while (iterator.hasNext()) {
                item = iterator.next();
                if (item == null) continue;
                return item;
            }
            this.iterator1 = null;
        }
        if ((iterator = this.iterator2) != null) {
            while (iterator.hasNext()) {
                item = iterator.next();
                if (item == null) continue;
                return item;
            }
            this.iterator2 = null;
        }
        if ((iterator = this.iterator3) != null) {
            while (iterator.hasNext()) {
                item = iterator.next();
                if (item == null) continue;
                return item;
            }
            this.iterator3 = null;
        }
        if ((iterator = this.iterator4) != null) {
            while (iterator.hasNext()) {
                item = iterator.next();
                if (item == null) continue;
                return item;
            }
            this.iterator4 = null;
        }
        return this.readCurrentIterator();
    }

    private T readCurrentIterator() {
        Iterator<T> iterator = this.getCurrentIterator();
        while (iterator != null) {
            while (iterator.hasNext()) {
                T item = iterator.next();
                if (item == null) continue;
                return item;
            }
            this.mCurrentIterator = null;
            iterator = this.getCurrentIterator();
        }
        return null;
    }

    private Iterator<? extends T> getCurrentIterator() {
        if (this.mCurrentIterator != null) {
            return this.mCurrentIterator;
        }
        Iterator<Iterator<E>> iteratorIterator = this.iteratorIterator;
        if (iteratorIterator == null) {
            return null;
        }
        Iterator<E> iterator = null;
        while (iteratorIterator.hasNext() && iterator == null) {
            iterator = iteratorIterator.next();
        }
        this.mCurrentIterator = iterator;
        return iterator;
    }

    public static <T1, E1 extends T1> Iterator<T1> of(Iterator<T1> iterator1, Iterator<Iterator<E1>> iteratorIterator) {
        if (!iteratorIterator.hasNext()) {
            return iterator1;
        }
        CombiningIterator iterator = new CombiningIterator(iterator1, null);
        iterator.iteratorIterator = iteratorIterator;
        return iterator;
    }

    public static <T1, E1 extends T1> Iterator<T1> of(T1 item, Iterator<Iterator<E1>> iteratorIterator) {
        if (!iteratorIterator.hasNext()) {
            return SingleIterator.of(item);
        }
        CombiningIterator iterator = new CombiningIterator(null, null);
        iterator.mCurrentItem = item;
        iterator.iteratorIterator = iteratorIterator;
        return iterator;
    }

    public static <T1> Iterator<T1> two(Iterator<? extends T1> iterator1, Iterator<? extends T1> iterator2) {
        if (!iterator1.hasNext()) {
            return iterator2;
        }
        if (!iterator2.hasNext()) {
            return iterator1;
        }
        return new CombiningIterator(iterator1, iterator2);
    }

    public static <T1> Iterator<T1> three(Iterator<? extends T1> iterator1, Iterator<? extends T1> iterator2, Iterator<? extends T1> iterator3) {
        return new CombiningIterator(iterator1, iterator2, iterator3);
    }

    public static <T1> Iterator<T1> four(Iterator<? extends T1> iterator1, Iterator<? extends T1> iterator2, Iterator<? extends T1> iterator3, Iterator<? extends T1> iterator4) {
        CombiningIterator iterator = new CombiningIterator(iterator1, iterator2, iterator3);
        iterator.iterator4 = iterator4;
        return iterator;
    }

    public static <T1> Iterator<T1> singleOne(T1 item, Iterator<? extends T1> iterator1) {
        if (item == null) {
            return iterator1;
        }
        CombiningIterator iterator = new CombiningIterator(iterator1, null);
        iterator.mCurrentItem = item;
        return iterator;
    }

    public static <T1> Iterator<T1> singleTwo(T1 item, Iterator<? extends T1> iterator1, Iterator<? extends T1> iterator2) {
        if (item == null) {
            return iterator1;
        }
        CombiningIterator iterator = new CombiningIterator(iterator1, iterator2);
        iterator.mCurrentItem = item;
        return iterator;
    }

    public static <T1> Iterator<T1> singleThree(T1 item, Iterator<? extends T1> iterator1, Iterator<? extends T1> iterator2, Iterator<? extends T1> iterator3) {
        if (item == null) {
            return iterator1;
        }
        CombiningIterator iterator = new CombiningIterator(iterator1, iterator2, iterator3);
        iterator.mCurrentItem = item;
        return iterator;
    }
}

