/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils.collection;

import com.reandroid.common.ArraySupplier;
import com.reandroid.utils.collection.ArrayIterator;
import com.reandroid.utils.collection.ArraySort;
import com.reandroid.utils.collection.ArraySupplierIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.FilterIterator;
import com.reandroid.utils.collection.InstanceIterator;
import com.reandroid.utils.collection.ListItr;
import com.reandroid.utils.collection.SizedIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Predicate;

public class ArrayCollection<T>
implements ArraySupplier<T>,
List<T>,
Set<T> {
    private Object[] mElements;
    private Initializer<T> mInitializer;
    private int size;
    private int mLastGrow;
    private int mHashCode;
    private boolean mLocked;
    private Monitor<T> mMonitor;
    static final Object[] EMPTY_OBJECTS = new Object[0];
    private static final int GROW_LIMIT = 8192;
    private static final ArrayCollection<?> EMPTY = new ArrayCollection<Object>(){

        @Override
        public Object[] toArray() {
            return EMPTY_OBJECTS;
        }

        @Override
        public void ensureCapacity(int capacity) {
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void addAll(Iterator<?> iterator) {
            throw new IllegalArgumentException("Empty ArrayCollection!");
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return false;
        }

        @Override
        public void removeAll() {
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean addAll(Collection<?> collection) {
            throw new IllegalArgumentException("Empty ArrayCollection!");
        }

        @Override
        public boolean add(Object item) {
            throw new IllegalArgumentException("Empty ArrayCollection!");
        }

        @Override
        public Object set(int i, Object item) {
            throw new IllegalArgumentException("Empty ArrayCollection!");
        }

        @Override
        public void add(int i, Object item) {
            throw new IllegalArgumentException("Empty ArrayCollection!");
        }

        @Override
        public Iterator<Object> iterator() {
            return EmptyIterator.of();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean isImmutableEmpty() {
            return true;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return false;
        }

        @Override
        public Object remove(int index) {
            return null;
        }

        @Override
        public boolean remove(Object obj) {
            return false;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void sort(Comparator<? super Object> comparator) {
        }

        @Override
        public void setSize(int size) {
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Collection) {
                return ((Collection)obj).size() == 0;
            }
            return false;
        }
    };

    public ArrayCollection(int initialCapacity) {
        Object[] elements = initialCapacity == 0 ? EMPTY_OBJECTS : new Object[initialCapacity];
        this.mElements = elements;
        this.size = 0;
    }

    public ArrayCollection(Object[] elements) {
        if (elements == null || elements.length == 0) {
            elements = EMPTY_OBJECTS;
        }
        this.mElements = elements;
        this.size = elements.length;
    }

    public ArrayCollection(Collection<? extends T> collection) {
        Object[] elements;
        int size = collection.size();
        if (size == 0) {
            elements = EMPTY_OBJECTS;
        } else {
            elements = collection.toArray();
            if (collection instanceof ArrayCollection) {
                elements = (Object[])elements.clone();
            }
        }
        this.mElements = elements;
        this.size = size;
    }

    public ArrayCollection() {
        this(0);
    }

    public Monitor<T> getMonitor() {
        return this.mMonitor;
    }

    public void setMonitor(Monitor<T> monitor) {
        this.mMonitor = monitor;
    }

    public Initializer<T> getInitializer() {
        return this.mInitializer;
    }

    public void setInitializer(Initializer<T> initializer) {
        this.mInitializer = initializer;
    }

    public ArrayCollection<T> copy() {
        return new ArrayCollection<T>((Object[])this.toArray().clone());
    }

    public ArrayCollection<T> filter(Predicate<? super T> filter) {
        int count = this.count(filter);
        if (count == this.size()) {
            return this;
        }
        ArrayCollection<? super T> collection = new ArrayCollection<T>(count);
        collection.addAll(this.iterator(filter));
        return collection;
    }

    public <T1 extends T> ArrayCollection<T1> filter(Class<T1> instance) {
        int count = this.count(instance);
        if (count == this.size()) {
            return this;
        }
        ArrayCollection<T1> collection = new ArrayCollection<T1>(count);
        collection.addAll(this.iterator(instance));
        return collection;
    }

    public int count(Predicate<? super T> filter) {
        return this.count(filter, this.size());
    }

    public int count(Predicate<? super T> filter, int limit) {
        int result = 0;
        int size = this.size();
        for (int i = 0; i < size && result < limit; ++i) {
            if (!filter.test(this.get(i))) continue;
            ++result;
        }
        return result;
    }

    public int count(Class<?> instance) {
        return this.count(instance, this.size());
    }

    public int count(Class<?> instance, int limit) {
        int result = 0;
        int size = this.size();
        Object[] elements = this.mElements;
        for (int i = 0; i < size && result < limit; ++i) {
            Object obj = elements[i];
            if (!instance.isInstance(obj)) continue;
            ++result;
        }
        return result;
    }

    @Override
    public void sort(Comparator<? super T> comparator) {
        if (this.mLocked) {
            return;
        }
        int size = this.size();
        if (size < 2) {
            return;
        }
        ArraySort.ObjectSort sort = new ArraySort.ObjectSort(this.mElements, 0, size, comparator){

            @Override
            public void onSwap(int i, int j) {
                super.onSwap(i, j);
                ArrayCollection.this.notifySwap(i, j);
            }
        };
        if (sort.sort()) {
            this.onChanged();
        }
    }

    public boolean sortItems(Comparator<? super T> comparator) {
        if (this.mLocked) {
            return false;
        }
        int size = this.size();
        if (size < 2) {
            return false;
        }
        ArraySort.ObjectSort sort = new ArraySort.ObjectSort(this.mElements, 0, size, comparator){

            @Override
            public void onSwap(int i, int j) {
                super.onSwap(i, j);
                ArrayCollection.this.notifySwap(i, j);
            }
        };
        if (sort.sort()) {
            this.onChanged();
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.containsFast(obj) || this.containsEquals(obj);
    }

    public boolean containsEquals(Object obj) {
        return this.indexOf(obj) >= 0;
    }

    public boolean containsFast(Object item) {
        return this.indexOfFast(item) >= 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isImmutableEmpty() {
        return false;
    }

    @Override
    public T getFirst() {
        if (this.size() == 0) {
            return null;
        }
        return this.get(0);
    }

    @Override
    public T getLast() {
        int size = this.size();
        if (size == 0) {
            return null;
        }
        return this.get(size - 1);
    }

    public T getElement(Object obj) {
        int i = this.indexOf(obj);
        if (i >= 0) {
            return this.get(i);
        }
        return null;
    }

    @Override
    public T get(int i) {
        return (T)this.mElements[i];
    }

    @Override
    public int size() {
        return this.size;
    }

    public void ensureSize(int size) {
        if (size > this.size()) {
            this.setSize(size);
        }
    }

    public void setSize(int size) {
        int start = this.size;
        if (size == start) {
            return;
        }
        if (size < start) {
            this.size = size;
            this.onChanged();
            this.notifyShrink(size);
            return;
        }
        boolean locked = this.mLocked;
        this.mLocked = true;
        int length = size - start;
        this.ensureCapacity(length);
        this.size = size;
        this.fillElements(this.mElements, start, length);
        this.mLocked = locked;
        this.onChanged();
    }

    private void fillElements(Object[] elements, int start, int length) {
        Initializer<T> initializer = this.getInitializer();
        if (initializer == null) {
            return;
        }
        length = start + length;
        for (int i = start; i < length; ++i) {
            T item = initializer.createNewItem(i);
            elements[i] = item;
            this.notifyAdd(i, item);
        }
    }

    @Override
    public int getCount() {
        return this.size();
    }

    public <T1> Iterator<T1> iterator(Class<T1> instance) {
        return InstanceIterator.of(this.iterator(), instance);
    }

    public Iterator<T> iterator(Predicate<? super T> filter) {
        return FilterIterator.of(this.iterator(), filter);
    }

    @Override
    public Iterator<T> iterator() {
        return ArraySupplierIterator.of(this);
    }

    public Iterator<T> iterator(int start) {
        return this.iterator(start, this.size() - start);
    }

    public Iterator<T> iterator(int start, int length) {
        return ArraySupplierIterator.of(this, start, length);
    }

    public Iterator<T> arrayIterator() {
        return ArrayIterator.of(this.mElements, 0, this.size());
    }

    public Iterator<T> clonedIterator() {
        if (this.isEmpty()) {
            return EmptyIterator.of();
        }
        return ArrayIterator.of((Object[])this.mElements.clone(), 0, this.size());
    }

    @Override
    public Object[] toArray() {
        return this.trimToSize(this.getElements(), this.size());
    }

    public Object[] getElements() {
        return this.mElements;
    }

    public void setElements(Object[] elements) {
        this.setElements(elements, elements.length);
    }

    public void setElements(Object[] elements, int size) {
        this.mElements = elements;
        this.size = size;
        this.onChanged();
        this.notifySet(elements, size);
    }

    @Override
    public <T1> T1[] toArray(T1[] out) {
        int size = this.size();
        if (size == 0) {
            return out;
        }
        Object[] elements = this.mElements;
        int length = out.length;
        if (length > 0 && length <= size) {
            for (int i = 0; i < length; ++i) {
                out[i] = elements[i];
            }
            return out;
        }
        return Arrays.copyOf(elements, size, out.getClass());
    }

    public T removeItem(Object item) {
        int i = this.indexOf(item);
        if (i < 0) {
            return null;
        }
        T result = this.get(i);
        this.remove(i);
        this.onChanged();
        return result;
    }

    @Override
    public List<T> subList(int start, int length) {
        int end = start + length;
        int size = this.size();
        if (end > size) {
            end = size;
        }
        if (start == 0 && end == size) {
            return this;
        }
        Object[] result = this.getNewArray(length);
        Object[] elements = this.mElements;
        for (int i = start; i < end; ++i) {
            result[i] = elements[i];
        }
        return new ArrayCollection<T>(result);
    }

    @Override
    public int indexOf(Object item) {
        return this.indexOf(item, 0, false);
    }

    public int indexOfFast(Object item) {
        return this.indexOf(item, 0, true);
    }

    public int indexOf(Object item, int start) {
        return this.indexOf(item, start, false);
    }

    public int indexOfFast(Object item, int start) {
        return this.indexOf(item, start, true);
    }

    @Override
    public int lastIndexOf(Object item) {
        return this.lastIndexOf(item, false);
    }

    @Override
    public Spliterator<T> spliterator() {
        throw new IllegalArgumentException("Not implemented");
    }

    @Override
    public ListIterator<T> listIterator() {
        return ListItr.of(this);
    }

    @Override
    public ListIterator<T> listIterator(int start) {
        return ListItr.of(this, start);
    }

    public int lastIndexOfFast(Object item) {
        return this.lastIndexOf(item, true);
    }

    private int indexOf(Object item, int start, boolean fast) {
        int i;
        int size;
        if (item == null) {
            return -1;
        }
        if (start < 0) {
            start = 0;
        }
        if ((size = this.size) == 0) {
            return -1;
        }
        Object[] elements = this.mElements;
        for (i = start; i < size; ++i) {
            if (!this.matches(item, elements[i], true)) continue;
            return i;
        }
        if (fast) {
            return -1;
        }
        for (i = start; i < size; ++i) {
            if (!this.matches(item, elements[i], false)) continue;
            return i;
        }
        return -1;
    }

    private boolean matches(Object item, Object obj, boolean fast) {
        if (obj == null) {
            return false;
        }
        if (item == obj) {
            return true;
        }
        if (fast) {
            return false;
        }
        return item.equals(obj);
    }

    private int lastIndexOf(Object item, boolean fast) {
        if (item == null) {
            return -1;
        }
        int result = -1;
        Object[] elements = this.mElements;
        int length = this.size;
        for (int i = 0; i < length; ++i) {
            Object obj = elements[i];
            if (obj == null) continue;
            if (fast) {
                if (item != obj) continue;
                result = i;
                continue;
            }
            if (!item.equals(obj)) continue;
            result = i;
        }
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return !collection.isEmpty();
    }

    public void addAll(int index, T[] items) {
        if (items == null) {
            return;
        }
        if (this.size() == 0) {
            this.setElements(items);
            return;
        }
        int size = items.length;
        this.ensureCapacity(size);
        for (int i = 0; i < size; ++i) {
            this.add(index + i, items[i]);
        }
    }

    public void addAll(T[] items) {
        if (items == null) {
            return;
        }
        this.addAll(this.size(), items);
    }

    public void addAll(Iterator<? extends T> iterator) {
        if (iterator == null) {
            return;
        }
        if (iterator instanceof SizedIterator) {
            int size = ((SizedIterator)((Object)iterator)).getRemainingSize();
            this.ensureCapacity(size);
        }
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    public void addIterable(Iterable<? extends T> iterable) {
        if (iterable == null) {
            return;
        }
        if (iterable instanceof Collection) {
            this.addAll((Collection)iterable);
            return;
        }
        this.addAll(iterable.iterator());
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        if (collection == null) {
            return false;
        }
        int size = this.size();
        if (size == 0) {
            Object[] elements = this.getNewArray(collection.toArray(), collection.size());
            this.setElements(elements);
            return true;
        }
        size = collection.size();
        boolean result = false;
        this.mLocked = true;
        for (T item : collection) {
            boolean added;
            if (this.availableCapacity() == 0) {
                this.ensureCapacity(size);
            }
            if (!(added = this.add(item))) continue;
            result = true;
        }
        this.mLocked = false;
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        int i;
        Object[] elements = this.mElements;
        if (elements == null) {
            return false;
        }
        int length = this.size;
        if (length == 0) {
            return false;
        }
        int result = 0;
        for (Object obj : collection) {
            if (length == result) break;
            for (i = 0; i < length; ++i) {
                Object item = elements[i];
                if (item != obj) continue;
                elements[i] = null;
                this.notifyRemoved(i, elements);
                ++result;
            }
        }
        if (result == 0) {
            return false;
        }
        this.size -= result;
        if (this.size == 0) {
            this.mElements = EMPTY_OBJECTS;
            return true;
        }
        Object[] update = this.getNewArray(this.size);
        int count = 0;
        for (i = 0; i < length; ++i) {
            Object obj = elements[i];
            if (obj == null) continue;
            update[count] = obj;
            ++count;
        }
        this.size = count;
        this.mElements = update;
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return false;
    }

    public void removeAll() {
        int size = this.size;
        this.size = 0;
        Object[] elements = this.mElements;
        this.mLocked = false;
        for (int i = 0; i < size; ++i) {
            elements[i] = null;
        }
        this.onChanged();
        this.notifyShrink(0);
    }

    @Override
    public void clear() {
        int size = this.size;
        this.size = 0;
        Object[] elements = this.mElements;
        this.mElements = EMPTY_OBJECTS;
        this.mLastGrow = 0;
        this.mLocked = false;
        for (int i = 0; i < size; ++i) {
            elements[i] = null;
        }
        this.onChanged();
        this.notifyShrink(0);
    }

    @Override
    public boolean remove(Object obj) {
        return this.removeItem(obj) != null;
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        boolean removed = false;
        for (int i = 0; i < this.size(); ++i) {
            if (!filter.test(this.get(i))) continue;
            this.remove(i);
            --i;
            removed = true;
        }
        return removed;
    }

    @Override
    public boolean add(T item) {
        if (item == null) {
            return false;
        }
        boolean locked = this.mLocked;
        this.mLocked = true;
        this.ensureCapacity();
        int index = this.size++;
        this.mElements[index] = item;
        this.mLocked = locked;
        this.onChanged();
        this.notifyAdd(index, item);
        return true;
    }

    @Override
    public void add(int i, T item) {
        if (item == null) {
            return;
        }
        boolean locked = this.mLocked;
        this.mLocked = true;
        this.slideRight(i, 1);
        this.mElements[i] = item;
        this.notifyAdd(i, item);
        this.mLocked = locked;
        this.onChanged();
    }

    public boolean swap(int i1, int i2) {
        if (i1 == i2) {
            return false;
        }
        Object[] elements = this.mElements;
        Object item = elements[i1];
        elements[i1] = elements[i2];
        elements[i2] = item;
        this.onChanged();
        return true;
    }

    public void move(int from, int to) {
        if (from == to) {
            return;
        }
        boolean locked = this.mLocked;
        this.mLocked = true;
        Object[] elements = this.mElements;
        Object item = elements[from];
        if (from > to) {
            for (int i = from; i > to; --i) {
                elements[i] = elements[i - 1];
            }
        } else {
            for (int i = from; i < to; ++i) {
                elements[i] = elements[i + 1];
            }
        }
        elements[to] = item;
        this.mElements = elements;
        this.mLocked = locked;
        this.onChanged();
    }

    @Override
    public T set(int i, T item) {
        if (item == null || i < 0) {
            return null;
        }
        this.ensureSize(i + 1);
        Object existing = this.mElements[i];
        this.mElements[i] = item;
        if (item != existing) {
            this.onChanged();
            this.notifySet(i, item);
        }
        return (T)existing;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> collection) {
        if (collection == null) {
            return false;
        }
        int length = collection.size();
        if (length == 0) {
            return false;
        }
        boolean locked = this.mLocked;
        this.mLocked = true;
        this.slideRight(index, length);
        Object[] elements = this.mElements;
        int i = index;
        for (T item : collection) {
            if (item == null || this.containsFast(item)) continue;
            elements[i] = item;
            this.notifyAdd(i, item);
            ++i;
        }
        int duplicates = length - (i - index);
        this.slideLeft(i, duplicates);
        this.mLocked = locked;
        return duplicates < length;
    }

    @Override
    public T remove(int index) {
        T result = this.get(index);
        this.slideLeft(index, 1);
        this.notifyRemoved(index, result);
        return result;
    }

    private void slideLeft(int position, int amount) {
        int i;
        if (amount == 0 || position < 0) {
            return;
        }
        boolean locked = this.mLocked;
        this.mLocked = true;
        Object[] elements = this.mElements;
        int size = this.size;
        int length = size - amount;
        for (i = position; i < length; ++i) {
            elements[i] = elements[i + amount];
        }
        for (i = length; i < size; ++i) {
            elements[i] = null;
        }
        this.size = length;
        this.mLocked = locked;
        this.onChanged();
    }

    private void slideRight(int position, int amount) {
        int i;
        boolean locked = this.mLocked;
        this.mLocked = true;
        this.ensureCapacity(amount);
        Object[] elements = this.mElements;
        int size = this.size;
        for (i = size - 1; i >= position; --i) {
            elements[i + amount] = elements[i];
        }
        this.size = size + amount;
        amount = position + amount;
        for (i = position; i < amount; ++i) {
            elements[i] = null;
        }
        this.mLocked = locked;
        this.onChanged();
    }

    public void trimToSize() {
        if (this.mLocked || this.availableCapacity() == 0) {
            if (this.mLastGrow == 0) {
                this.mLastGrow = this.size() / 3;
            }
            return;
        }
        this.mElements = this.trimToSize(this.mElements, this.size);
        this.mLastGrow = this.size / 4;
    }

    private Object[] trimToSize(Object[] elements, int size) {
        if (size >= elements.length) {
            return elements;
        }
        if (size == 0) {
            return this.getNewArray(0);
        }
        Object[] update = this.getNewArray(size);
        this.arrayCopy(elements, update, size);
        return update;
    }

    private void arrayCopy(Object[] source, Object[] destination, int length) {
        for (int i = 0; i < length; ++i) {
            destination[i] = source[i];
        }
    }

    private Object[] getNewArray(Object[] source, int length) {
        Object[] result = this.getNewArray(length);
        this.arrayCopy(source, result, length);
        return result;
    }

    private Object[] getNewArray(int length) {
        Initializer<T> initializer = this.getInitializer();
        if (initializer != null) {
            return initializer.newArray(length);
        }
        if (length == 0) {
            return EMPTY_OBJECTS;
        }
        return new Object[length];
    }

    private void ensureCapacity() {
        if (this.availableCapacity() > 0) {
            return;
        }
        this.ensureCapacity(this.calculateGrow());
    }

    public void ensureCapacity(int capacity) {
        if (capacity <= 0) {
            return;
        }
        if ((capacity -= this.availableCapacity()) <= 0) {
            return;
        }
        int size = this.size;
        int length = size + capacity;
        Object[] update = this.getNewArray(length);
        Object[] elements = this.mElements;
        if (elements.length == 0 || size == 0) {
            this.mElements = update;
            this.notifyGrow(length);
            return;
        }
        this.arrayCopy(elements, update, size);
        this.mElements = update;
        this.notifyGrow(length);
    }

    public int availableCapacity() {
        return this.mElements.length - this.size;
    }

    private int calculateGrow() {
        if (this.size == 0) {
            return 1;
        }
        int amount = this.mLastGrow;
        if (amount >= 8192) {
            return amount;
        }
        if (amount == 0) {
            amount = 1;
        }
        if ((amount <<= 1) > 32) {
            amount <<= 1;
        }
        if (amount > 32 && amount < 256) {
            amount <<= 1;
        }
        if (amount > 8192) {
            amount = 8192;
        }
        this.mLastGrow = amount;
        if (this.size < 4) {
            amount = 1;
        }
        return amount;
    }

    public void onChanged() {
        this.mHashCode = 0;
    }

    private void notifyAdd(int i, T item) {
        Monitor<T> monitor = this.getMonitor();
        if (monitor != null) {
            monitor.onAdd(i, item);
        }
    }

    private void notifyRemoved(int i, T item) {
        Monitor<T> monitor = this.getMonitor();
        if (monitor != null) {
            monitor.onRemoved(i, item);
        }
    }

    private void notifySet(int i, T item) {
        Monitor<T> monitor = this.getMonitor();
        if (monitor != null) {
            monitor.onSet(i, item);
        }
    }

    private void notifySet(Object[] elements, int size) {
        Monitor<T> monitor = this.getMonitor();
        if (monitor != null) {
            monitor.onSet(elements, size);
        }
    }

    private void notifyGrow(int size) {
        Monitor<T> monitor = this.getMonitor();
        if (monitor != null) {
            monitor.onGrow(size);
        }
    }

    private void notifyShrink(int size) {
        Monitor<T> monitor = this.getMonitor();
        if (monitor != null) {
            monitor.onShrink(size);
        }
    }

    void notifySwap(int i, int j) {
        Monitor<T> monitor = this.getMonitor();
        if (monitor != null) {
            monitor.onSwap(i, j);
        }
    }

    @Override
    public int hashCode() {
        if (this.mHashCode != 0) {
            return this.mHashCode;
        }
        this.mHashCode = this.computeHashCode();
        return this.mHashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayCollection collection = (ArrayCollection)obj;
        int size = this.size();
        if (size != collection.size() || this.hashCode() != collection.hashCode()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (Objects.equals(this.get(i), collection.get(i))) continue;
            return false;
        }
        return true;
    }

    public int computeHashCode() {
        int size = this.size();
        if (size == 0) {
            return 0;
        }
        int hashSum = 1;
        Object[] elements = this.mElements;
        for (int i = 0; i < size; ++i) {
            Object obj = elements[i];
            int hash = obj == null ? 0 : obj.hashCode();
            hashSum = 31 * hashSum + hash;
        }
        this.mHashCode = hashSum;
        return hashSum;
    }

    public String toString() {
        if (this.size() == 0) {
            return "EMPTY";
        }
        return this.size() + "{" + this.get(0) + "}";
    }

    public static <T> ArrayCollection<T> of(Iterable<? extends T> iterable) {
        if (iterable == null) {
            return ArrayCollection.empty();
        }
        ArrayCollection<? extends T> collection = new ArrayCollection<T>();
        collection.addIterable(iterable);
        collection.trimToSize();
        return collection;
    }

    public static <T> ArrayCollection<T> of(Iterator<? extends T> iterator) {
        ArrayCollection<? extends T> collection = new ArrayCollection<T>();
        collection.addAll(iterator);
        collection.trimToSize();
        return collection;
    }

    public static <T> ArrayCollection<T> empty() {
        return EMPTY;
    }

    public static interface Monitor<T> {
        public void onAdd(int var1, T var2);

        public void onRemoved(int var1, T var2);

        public void onSet(int var1, T var2);

        public void onSet(Object[] var1, int var2);

        public void onGrow(int var1);

        public void onShrink(int var1);

        public void onSwap(int var1, int var2);
    }

    public static interface Initializer<T1> {
        public T1 createNewItem(int var1);

        public T1[] newArray(int var1);
    }
}

