/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils;

import com.reandroid.utils.StringsUtil;
import java.util.Arrays;
import java.util.Comparator;

public class CompareUtil {
    public static final Comparator<String> STRING_COMPARATOR = CompareUtil::compare;
    private static final Comparator<?> TO_STRING_COMPARATOR = StringsUtil::compareToString;
    private static final Comparator<Comparable<?>> COMPARATOR = new Comparator<Comparable<?>>(){

        @Override
        public int compare(Comparable comparable1, Comparable comparable2) {
            return CompareUtil.compare(comparable1, comparable2);
        }
    };

    public static <T extends Comparable<T>> void sort(T[] items) {
        if (items == null || items.length < 2) {
            return;
        }
        Arrays.sort(items, CompareUtil.getComparableComparator());
    }

    public static <T extends Comparable<? super T>> int compare(T[] items1, T[] items2) {
        if (items1 == items2) {
            return 0;
        }
        boolean empty1 = CompareUtil.isEmpty(items1);
        boolean empty2 = CompareUtil.isEmpty(items2);
        if (empty1 && empty2) {
            return 0;
        }
        if (empty1) {
            return -1;
        }
        if (empty2) {
            return 1;
        }
        int length1 = items1.length;
        int length = length1;
        int length2 = items2.length;
        if (length > length2) {
            length = length2;
        }
        for (int i = 0; i < length; ++i) {
            int compare = CompareUtil.compare(items1[i], items2[i]);
            if (compare == 0) continue;
            return compare;
        }
        return Integer.compare(length1, length2);
    }

    private static boolean isEmpty(Object[] objects) {
        return objects == null || objects.length == 0;
    }

    public static int compare(int i1, int i2) {
        if (i1 == i2) {
            return 0;
        }
        if (i1 > i2) {
            return 1;
        }
        return -1;
    }

    public static <T extends Comparable<? super T>> int compare(T item1, T item2) {
        if (item1 == item2) {
            return 0;
        }
        if (item1 == null) {
            return -1;
        }
        if (item2 == null) {
            return 1;
        }
        int i = item1.compareTo(item2);
        if (i == 0) {
            return 0;
        }
        if (i > 0) {
            return 1;
        }
        return -1;
    }

    public static <T> Comparator<T> getComparatorUnchecked() {
        return COMPARATOR;
    }

    public static <E, T extends Comparable<E>> Comparator<T> getComparableComparator() {
        return COMPARATOR;
    }

    public static <T1> Comparator<T1> getToStringComparator() {
        return TO_STRING_COMPARATOR;
    }
}

