/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.graphics;

import com.reandroid.utils.HexUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class AndroidColor {
    private int alpha;
    private int red;
    private int green;
    private int blue;
    private Type type;
    private boolean upperCase;
    public static final double LENGTH = ObjectsUtil.of(441.67);

    public AndroidColor(int alpha, int red, int green, int blue) {
        this.alpha = alpha;
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public AndroidColor() {
        this(0, 0, 0, 0);
    }

    public void setUpperCase(boolean upperCase) {
        this.upperCase = upperCase;
    }

    public AndroidColor copy() {
        AndroidColor color = new AndroidColor(this.alpha, this.red, this.green, this.blue);
        color.setType(this.getType());
        color.setUpperCase(this.upperCase);
        return color;
    }

    public AndroidColor inverse() {
        AndroidColor color = this.copy();
        int mask = this.getType().mask();
        color.red(~color.red() & mask);
        color.green(~color.green() & mask);
        color.blue(~color.blue() & mask);
        return color;
    }

    public AndroidColor argb() {
        AndroidColor color = new AndroidColor(0, this.red, this.green, this.blue);
        Type type = this.getType();
        type = type.isEightBit() ? Type.ARGB8 : Type.ARGB4;
        color.setType(type);
        color.setUpperCase(this.upperCase);
        color.alpha(this.alpha());
        return color;
    }

    public AndroidColor rgb() {
        AndroidColor color = new AndroidColor(0, this.red, this.green, this.blue);
        Type type = this.getType();
        type = type.isEightBit() ? Type.RGB8 : Type.RGB4;
        color.setType(type);
        color.setUpperCase(this.upperCase);
        return color;
    }

    public AndroidColor toEightBit() {
        if (this.isEightBit()) {
            return this;
        }
        AndroidColor color = this.copy();
        color.setEightBit(true);
        return color;
    }

    public AndroidColor toFourBit() {
        if (!this.isEightBit()) {
            return this;
        }
        AndroidColor color = this.copy();
        color.setEightBit(false);
        return color;
    }

    public boolean hasAlpha() {
        return this.getType().hasAlpha();
    }

    public void setHasAlpha(boolean hasAlpha) {
        Type type = this.getType();
        if (hasAlpha != type.hasAlpha()) {
            if (type == Type.ARGB4) {
                type = Type.RGB4;
            } else if (type == Type.RGB4) {
                type = Type.ARGB4;
            } else if (type == Type.ARGB8) {
                type = Type.RGB8;
            } else if (type == Type.RGB8) {
                type = Type.ARGB8;
            }
            int alpha = 0;
            if (hasAlpha) {
                alpha = type.fit(this.alpha());
            }
            this.setType(type);
            this.alpha(alpha);
        }
    }

    public int alpha() {
        return this.alpha;
    }

    public void alpha(int alpha) {
        if (this.alpha != alpha || alpha == 0) {
            this.alpha = this.getType().fit(alpha);
        }
    }

    public int red() {
        return this.red;
    }

    public void red(int red) {
        this.red = this.getType().fit(red);
    }

    public int green() {
        return this.green;
    }

    public void green(int green) {
        this.green = this.getType().fit(green);
    }

    public int blue() {
        return this.blue;
    }

    public void blue(int blue) {
        this.blue = this.getType().fit(blue);
    }

    public AndroidColor addRgb(int amount) {
        int i;
        if (amount == 0) {
            return this;
        }
        AndroidColor color = this.copy();
        int max = 15;
        if (color.isEightBit()) {
            max = 255;
        }
        if ((i = color.red + amount) < 0 || i > max) {
            return this;
        }
        color.red = i;
        i = color.green + amount;
        if (i < 0 || i > max) {
            return this;
        }
        color.green = i;
        i = color.blue + amount;
        if (i < 0 || i > max) {
            return this;
        }
        color.blue = i;
        return color;
    }

    public boolean isEightBit() {
        return this.getType().isEightBit();
    }

    public void setEightBit(boolean eightBit) {
        int scale;
        int max;
        Type type = this.getType();
        if (eightBit == type.isEightBit()) {
            return;
        }
        if (eightBit) {
            max = 255;
            scale = 15;
            type = type.toEightBit();
        } else {
            max = 15;
            scale = 255;
            type = type.toFourBit();
        }
        this.alpha = this.alpha * max / scale;
        this.red = this.red * max / scale;
        this.green = this.green * max / scale;
        this.blue = this.blue * max / scale;
        this.type = type;
    }

    public Type getType() {
        Type type = this.type;
        if (type == null) {
            type = Type.getFor(this.alpha(), this.red(), this.green(), this.blue());
        }
        return type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String toHexString() {
        Type type = this.getType();
        StringBuilder builder = new StringBuilder();
        builder.append('#');
        int width = 1;
        if (type.isEightBit()) {
            width = 2;
        }
        if (type.hasAlpha()) {
            builder.append(HexUtil.toHex(null, this.alpha, width));
        }
        builder.append(HexUtil.toHex(null, this.red, width));
        builder.append(HexUtil.toHex(null, this.green, width));
        builder.append(HexUtil.toHex(null, this.blue, width));
        String hex = builder.toString();
        if (this.upperCase) {
            hex = StringsUtil.toUpperCase(hex);
        }
        return hex;
    }

    public int intValue() {
        int value = this.alpha << 24;
        value |= this.red << 16;
        value |= this.green << 8;
        return value |= this.blue;
    }

    public int compareTo(AndroidColor reference, AndroidColor color) {
        return Double.compare(reference.distance(this), reference.distance(color));
    }

    public double distance(AndroidColor other) {
        if (other == this) {
            return 0.0;
        }
        AndroidColor color = this;
        if (color.isEightBit() != other.isEightBit()) {
            if (color.isEightBit()) {
                other = other.toEightBit();
            } else {
                color = color.toEightBit();
            }
        }
        double d = AndroidColor.deltaSquare(other.red(), color.red());
        d += (double)AndroidColor.deltaSquare(other.green(), color.green());
        d += (double)AndroidColor.deltaSquare(other.blue(), color.blue());
        d = Math.sqrt(d);
        long l = Math.round(d *= 100.0);
        d = (double)l / 100.0;
        return d;
    }

    public boolean equalsRgb(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AndroidColor)) {
            return false;
        }
        AndroidColor other = (AndroidColor)obj;
        AndroidColor color = this;
        if (color.isEightBit() != other.isEightBit()) {
            if (color.isEightBit()) {
                other = other.toEightBit();
            } else {
                color = color.toEightBit();
            }
        }
        return color.red == other.red && color.green == other.green && color.blue == other.blue;
    }

    public boolean equals(AndroidColor color, float percent) {
        if (color == null) {
            return false;
        }
        if (color == this) {
            return true;
        }
        return this.distance(color) <= AndroidColor.toDistance(percent);
    }

    public boolean equals(AndroidColor color, double distanceTolerance) {
        if (color == null) {
            return false;
        }
        if (color == this) {
            return true;
        }
        return this.distance(color) <= distanceTolerance;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AndroidColor)) {
            return false;
        }
        AndroidColor other = (AndroidColor)obj;
        AndroidColor color = this;
        if (color.isEightBit() != other.isEightBit()) {
            if (color.isEightBit()) {
                other = other.toEightBit();
            } else {
                color = color.toEightBit();
            }
        }
        return color.alpha == other.alpha && color.red == other.red && color.green == other.green && color.blue == other.blue;
    }

    public int hashCode() {
        return this.intValue();
    }

    public String toString() {
        return this.toHexString();
    }

    public static ColorIterator decodeAll(String text) {
        return new ColorIterator(text);
    }

    public static AndroidColor decode(String text) {
        char ch;
        if (text == null) {
            return null;
        }
        int length = text.length();
        if (length < 4) {
            return null;
        }
        if (text.charAt(0) != '#') {
            return null;
        }
        StringBuilder builder = new StringBuilder(9);
        builder.append('#');
        for (int i = 1; i < length && HexUtil.isHexChar(ch = text.charAt(i)); ++i) {
            if (i > 8) {
                return null;
            }
            builder.append(ch);
        }
        return AndroidColor.parseHex(builder.toString(), false);
    }

    public static AndroidColor parseHex(String hexColor) {
        return AndroidColor.parseHex(hexColor, true);
    }

    private static AndroidColor parseHex(String hexColor, boolean fail) {
        int i;
        if (hexColor == null || hexColor.length() == 0 || hexColor.charAt(0) != '#') {
            if (fail) {
                throw new NumberFormatException("Invalid hex color: " + hexColor);
            }
            return null;
        }
        Type type = Type.valueOf(hexColor.length());
        if (type == null) {
            if (fail) {
                throw new NumberFormatException("Invalid hex color string length: " + hexColor);
            }
            return null;
        }
        String current = hexColor;
        AndroidColor color = new AndroidColor();
        color.type = type;
        current = current.substring(1);
        color.setUpperCase(StringsUtil.containsUpperAZ(current));
        int width = 1;
        if (type.isEightBit()) {
            width = 2;
        }
        int error = -1;
        if (type.hasAlpha()) {
            i = HexUtil.decodeHex(current.substring(0, width), error);
            if (i == error) {
                if (fail) {
                    throw new NumberFormatException("Invalid hex: " + hexColor);
                }
                return null;
            }
            color.alpha = i;
            current = current.substring(width);
        }
        if ((i = HexUtil.decodeHex(current.substring(0, width), error)) == error) {
            if (fail) {
                throw new NumberFormatException("Invalid hex: " + hexColor);
            }
            return null;
        }
        color.red = i;
        i = HexUtil.decodeHex((current = current.substring(width)).substring(0, width), error);
        if (i == error) {
            if (fail) {
                throw new NumberFormatException("Invalid hex: " + hexColor);
            }
            return null;
        }
        color.green = i;
        i = HexUtil.decodeHex((current = current.substring(width)).substring(0, width), error);
        if (i == error) {
            if (fail) {
                throw new NumberFormatException("Invalid hex: " + current);
            }
            return null;
        }
        color.blue = i;
        return color;
    }

    private static int deltaSquare(int i1, int i2) {
        int i = i1 - i2;
        return i * i;
    }

    public static float toPercent(double distance) {
        return (float)(distance * 100.0 / LENGTH);
    }

    public static double toDistance(float percent) {
        return (double)percent * LENGTH / 100.0;
    }

    public static class ColorIterator
    implements Iterator<AndroidColor> {
        private String text;
        private AndroidColor current;
        private String lastColor;
        private int index;
        private int lastIndex;

        public ColorIterator(String text) {
            this.text = text;
            this.lastIndex = -1;
        }

        public String getText() {
            return this.text;
        }

        public String replace(AndroidColor color) {
            String text = this.getText();
            if (color == null || this.lastColor == null) {
                return text;
            }
            String left = text.substring(0, this.lastIndex);
            String right = text.substring(this.lastIndex + this.lastColor.length());
            this.lastColor = color.toHexString();
            this.text = text = left + this.lastColor + right;
            return text;
        }

        @Override
        public void remove() {
            String lastColor = this.lastColor;
            if (lastColor == null) {
                return;
            }
            String text = this.getText();
            this.lastColor = null;
            String left = text.substring(0, this.lastIndex);
            String right = text.substring(this.lastIndex + lastColor.length());
            this.text = left + right;
        }

        @Override
        public boolean hasNext() {
            return this.getNext() != null;
        }

        @Override
        public AndroidColor next() {
            AndroidColor color = this.getNext();
            if (color == null) {
                throw new NoSuchElementException();
            }
            this.lastColor = color.toHexString();
            this.current = null;
            return color;
        }

        private int nextIndex() {
            if (this.text == null) {
                return -1;
            }
            int length = this.text.length();
            while (this.index < length) {
                if (this.text.charAt(this.index) == '#') {
                    return this.index;
                }
                ++this.index;
            }
            return -1;
        }

        private AndroidColor getNext() {
            while (this.current == null && this.nextIndex() != -1) {
                this.current = AndroidColor.decode(this.text.substring(this.index));
                if (this.current != null) {
                    this.lastIndex = this.index;
                }
                ++this.index;
            }
            return this.current;
        }
    }

    public static class Type {
        public static final Type RGB4 = new Type("RGB4", false, false);
        public static final Type ARGB4 = new Type("ARGB4", true, false);
        public static final Type RGB8 = new Type("RGB8", false, true);
        public static final Type ARGB8 = new Type("ARGB8", true, true);
        private final String name;
        private final boolean hasAlpha;
        private final boolean eightBit;

        private Type(String name, boolean hasAlpha, boolean eightBit) {
            this.name = name;
            this.hasAlpha = hasAlpha;
            this.eightBit = eightBit;
        }

        public boolean fits(int alpha, int red, int green, int blue) {
            if (alpha != 0 && !this.hasAlpha) {
                return false;
            }
            int mask = this.mask();
            return (alpha & mask) == alpha && (red & mask) == red && (red & mask) == green && (red & mask) == blue;
        }

        public int fit(int value) {
            int mask = this.mask();
            if (value > mask) {
                return mask;
            }
            if (value < 0) {
                return 0;
            }
            return value;
        }

        public int mask() {
            if (this.eightBit) {
                return 255;
            }
            return 15;
        }

        public boolean hasAlpha() {
            return this.hasAlpha;
        }

        public boolean isEightBit() {
            return this.eightBit;
        }

        public Type toEightBit() {
            if (this.isEightBit()) {
                return this;
            }
            if (this == RGB4) {
                return RGB8;
            }
            return ARGB8;
        }

        public Type toFourBit() {
            if (!this.isEightBit()) {
                return this;
            }
            if (this == RGB8) {
                return RGB4;
            }
            return ARGB4;
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }

        public static Type getFor(int alpha, int red, int green, int blue) {
            if (RGB4.fits(alpha, red, green, blue)) {
                return RGB4;
            }
            if (ARGB4.fits(alpha, red, green, blue)) {
                return ARGB4;
            }
            if (RGB8.fits(alpha, red, green, blue)) {
                return RGB8;
            }
            return ARGB8;
        }

        public static Type valueOf(int hexStringLength) {
            if (hexStringLength == 4) {
                return RGB4;
            }
            if (hexStringLength == 5) {
                return ARGB4;
            }
            if (hexStringLength == 7) {
                return RGB8;
            }
            if (hexStringLength == 9) {
                return ARGB8;
            }
            return null;
        }
    }
}

