/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.value;

import com.reandroid.arsc.base.Block;
import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.data.AnnotationElement;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.dex.value.SectionValue;
import com.reandroid.utils.collection.SingleIterator;
import java.util.Iterator;

public abstract class SectionIdValue<T extends IdItem>
extends SectionValue<T> {
    public SectionIdValue(SectionType<T> sectionType, DexValueType<?> type) {
        super(sectionType, type);
    }

    public void setKey(Key key) {
        this.setItem(key);
    }

    @Override
    public Key getKey() {
        IdItem item = (IdItem)this.getItem();
        if (item != null) {
            return item.getKey();
        }
        return null;
    }

    @Override
    int getSectionValue(T data) {
        if (data == null) {
            throw new NullPointerException("Section data can not be null: " + this.getSectionType().getName());
        }
        return ((Block)data).getIndex();
    }

    @Override
    T getReplacement(T data) {
        if (data != null) {
            data = (IdItem)((SectionItem)data).getReplace();
        }
        if (data == null) {
            throw new NullPointerException("Section data can not be null: " + this.getSectionType().getName());
        }
        return data;
    }

    @Override
    void updateUsageType(T data) {
        if (data != null) {
            int usage = this.getParent(AnnotationElement.class) != null ? UsageMarker.USAGE_ANNOTATION : UsageMarker.USAGE_ENCODED_VALUE;
            ((SectionItem)data).addUsageType(usage);
        }
    }

    @Override
    public void replaceKeys(Key search, Key replace) {
        Key key2;
        Key key = this.getKey();
        if (key != (key2 = key.replaceKey(search, replace))) {
            this.setItem(key2);
        }
    }

    @Override
    public void editInternal(Block user) {
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return SingleIterator.of((IdItem)this.getItem());
    }
}

