/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.value;

import com.reandroid.arsc.io.BlockReader;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.value.DexValueBlock;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.dex.value.NumberValue;
import java.io.IOException;

public abstract class PrimitiveValueBlock
extends DexValueBlock<NumberValue> {
    public PrimitiveValueBlock(DexValueType<?> type) {
        super(new NumberValue(), type);
    }

    @Override
    public abstract Number getData();

    @Override
    public void setData(Object number) {
        this.setData((Number)number);
    }

    public abstract void setData(Number var1);

    public long getNumberValue() {
        return ((NumberValue)this.getValueContainer()).getNumberValue();
    }

    public void setNumberValue(int value) {
        this.setNumberValue(0xFFFFFFFFL & (long)value);
    }

    public void setNumberValue(long value) {
        NumberValue container = (NumberValue)this.getValueContainer();
        container.setNumberValue(value);
        this.setValueSize(container.getSize() - 1);
    }

    public abstract String getHex();

    @Override
    public String getAsString() {
        return this.getHex();
    }

    @Override
    public abstract TypeKey getDataTypeKey();

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        this.getValueTypeItem().onReadBytes(reader);
        NumberValue container = (NumberValue)this.getValueContainer();
        container.setSize(this.getValueSize() + 1);
        container.readBytes(reader);
    }

    @Override
    public void merge(DexValueBlock<?> valueBlock) {
        super.merge(valueBlock);
        PrimitiveValueBlock coming = (PrimitiveValueBlock)valueBlock;
        ((NumberValue)this.getValueContainer()).merge((NumberValue)coming.getValueContainer());
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.append(this.getHex());
    }

    @Override
    public String toString() {
        return this.getHex();
    }
}

