/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.value;

import com.reandroid.dex.base.DexBlockItem;
import com.reandroid.utils.HexUtil;

public class NumberValue
extends DexBlockItem {
    public NumberValue() {
        super(1);
    }

    public int getSize() {
        return this.countBytes();
    }

    public void setSize(int size) {
        this.setBytesLength(size, false);
    }

    public long getSignedValue() {
        int size = this.getSize();
        long value = this.getNumberValue();
        if (size == 1) {
            return (byte)value;
        }
        if (size == 2) {
            return (short)value;
        }
        if (size < 5) {
            return (int)value;
        }
        return value;
    }

    public int getIntegerValue() {
        return (int)this.getNumberValue();
    }

    public long getNumberValue() {
        return NumberValue.getNumber(this.getBytesInternal(), 0, this.getSize());
    }

    public void setNumberValue(byte value) {
        this.setSize(1);
        this.getBytesInternal()[0] = value;
    }

    public void setNumberValue(short value) {
        byte b;
        if (value < 0 && value == (b = (byte)(value & 0xFF))) {
            this.setNumberValue(b);
            return;
        }
        this.setNumberValue((long)value & 0xFFFFL);
    }

    public void setNumberValue(int value) {
        short s;
        if (value < 0 && value == (s = (short)(value & 0xFFFF))) {
            this.setNumberValue(s);
            return;
        }
        this.setNumberValue((long)value & 0xFFFFFFFFL);
    }

    public void setNumberValue(long value) {
        int size = NumberValue.calculateSize(value);
        this.setSize(size);
        NumberValue.putNumber(this.getBytesInternal(), 0, size, value);
    }

    public String toHex() {
        return HexUtil.toHex(this.getNumberValue(), this.getSize());
    }

    public void merge(NumberValue value) {
        byte[] coming = value.getBytes();
        int length = coming.length;
        this.setBytesLength(length, false);
        byte[] bytes = this.getBytesInternal();
        for (int i = 0; i < length; ++i) {
            bytes[i] = coming[i];
        }
    }

    public int hashCode() {
        return Long.hashCode(this.getNumberValue());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.getNumberValue() == ((NumberValue)obj).getNumberValue();
    }

    public String toString() {
        return this.getSize() + ":" + this.toHex() + ":" + this.getSignedValue();
    }

    private static int calculateSize(long value) {
        if (value == 0L) {
            return 1;
        }
        int i = 0;
        while (value != 0L) {
            value >>>= 8;
            ++i;
        }
        return i;
    }
}

