/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.value;

import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliValue;
import com.reandroid.dex.smali.model.SmaliValueLong;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.dex.value.PrimitiveValueBlock;
import com.reandroid.utils.HexUtil;
import java.io.IOException;

public class LongValue
extends PrimitiveValueBlock {
    public LongValue() {
        super(DexValueType.LONG);
    }

    @Override
    public Long getData() {
        return this.get();
    }

    @Override
    public void setData(Number number) {
        this.set((Long)number);
    }

    public long get() {
        return this.getNumberValue();
    }

    public void set(long value) {
        this.setNumberValue(value);
    }

    @Override
    public DexValueType<?> getValueType() {
        return DexValueType.LONG;
    }

    @Override
    public String getHex() {
        return HexUtil.toHex(this.getNumberValue(), this.getValueSize()) + "L";
    }

    @Override
    public TypeKey getDataTypeKey() {
        return TypeKey.TYPE_J;
    }

    @Override
    public void fromSmali(SmaliValue smaliValue) {
        SmaliValueLong smaliValueLong = (SmaliValueLong)smaliValue;
        this.set(smaliValueLong.getValue());
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        super.append(writer);
        writer.appendComment(Long.toString(this.get()));
    }

    @Override
    public String toString() {
        return this.getHex() + " # " + this.get();
    }
}

