/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.value;

import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliValue;
import com.reandroid.dex.smali.model.SmaliValueFloat;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.dex.value.PrimitiveValueBlock;
import com.reandroid.utils.HexUtil;
import java.io.IOException;

public class FloatValue
extends PrimitiveValueBlock {
    public FloatValue() {
        super(DexValueType.FLOAT);
    }

    @Override
    public Float getData() {
        return Float.valueOf(this.get());
    }

    @Override
    public void setData(Number number) {
        this.set(((Float)number).floatValue());
    }

    public float get() {
        int shift = (3 - this.getValueSize()) * 8;
        int value = (int)this.getNumberValue();
        return Float.intBitsToFloat(value << shift);
    }

    public void set(float value) {
        this.setNumberValue(Float.floatToIntBits(value));
    }

    @Override
    public DexValueType<?> getValueType() {
        return DexValueType.FLOAT;
    }

    @Override
    public String getHex() {
        return HexUtil.toHex(this.getNumberValue(), this.getValueSize()) + "L";
    }

    @Override
    public TypeKey getDataTypeKey() {
        return TypeKey.TYPE_F;
    }

    @Override
    public void fromSmali(SmaliValue smaliValue) {
        SmaliValueFloat smaliValueFloat = (SmaliValueFloat)smaliValue;
        this.set(smaliValueFloat.getValue());
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.append(this.get());
    }

    @Override
    public String toString() {
        return this.getHex() + " # " + this.get();
    }
}

