/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.value;

import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliValue;
import com.reandroid.dex.smali.model.SmaliValueDouble;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.dex.value.PrimitiveValueBlock;
import com.reandroid.utils.HexUtil;
import java.io.IOException;

public class DoubleValue
extends PrimitiveValueBlock {
    public DoubleValue() {
        super(DexValueType.DOUBLE);
    }

    @Override
    public Double getData() {
        return this.get();
    }

    @Override
    public void setData(Number number) {
        this.set((Double)number);
    }

    public double get() {
        int shift = (7 - this.getValueSize()) * 8;
        long value = this.getNumberValue();
        return Double.longBitsToDouble(value << shift);
    }

    public void set(double value) {
        this.setNumberValue(Double.doubleToLongBits(value));
    }

    @Override
    public DexValueType<?> getValueType() {
        return DexValueType.DOUBLE;
    }

    @Override
    public String getHex() {
        int shift = (7 - this.getValueSize()) * 8;
        return HexUtil.toHex(this.getNumberValue() << shift, 8) + "L";
    }

    @Override
    public TypeKey getDataTypeKey() {
        return TypeKey.TYPE_D;
    }

    @Override
    public void fromSmali(SmaliValue smaliValue) {
        SmaliValueDouble smaliValueDouble = (SmaliValueDouble)smaliValue;
        this.set(smaliValueDouble.getValue());
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.append(this.get());
    }

    @Override
    public String toString() {
        return this.getHex() + " # " + this.get();
    }
}

