/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.value;

import com.reandroid.arsc.base.BlockCreator;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.value.AnnotationValue;
import com.reandroid.dex.value.ArrayValue;
import com.reandroid.dex.value.BooleanValue;
import com.reandroid.dex.value.ByteValue;
import com.reandroid.dex.value.CharValue;
import com.reandroid.dex.value.DexValueBlock;
import com.reandroid.dex.value.DoubleValue;
import com.reandroid.dex.value.EnumValue;
import com.reandroid.dex.value.FieldIdValue;
import com.reandroid.dex.value.FloatValue;
import com.reandroid.dex.value.IntValue;
import com.reandroid.dex.value.LongValue;
import com.reandroid.dex.value.MethodHandleValue;
import com.reandroid.dex.value.MethodIdValue;
import com.reandroid.dex.value.NullValue;
import com.reandroid.dex.value.ProtoValue;
import com.reandroid.dex.value.SectionIdValue;
import com.reandroid.dex.value.SectionValue;
import com.reandroid.dex.value.ShortValue;
import com.reandroid.dex.value.StringValue;
import com.reandroid.dex.value.TypeValue;
import com.reandroid.utils.HexUtil;
import java.io.IOException;

public class DexValueType<T extends DexValueBlock<?>>
implements BlockCreator<T> {
    private static final DexValueType<?>[] VALUES;
    private static final DexValueType<?>[] VALUES_COPY;
    public static final DexValueType<ByteValue> BYTE;
    public static final DexValueType<ShortValue> SHORT;
    public static final DexValueType<CharValue> CHAR;
    public static final DexValueType<IntValue> INT;
    public static final DexValueType<LongValue> LONG;
    public static final DexValueType<FloatValue> FLOAT;
    public static final DexValueType<DoubleValue> DOUBLE;
    public static final DexValueType<ProtoValue> PROTO;
    public static final DexValueType<MethodHandleValue> METHOD_HANDLE;
    public static final DexValueType<StringValue> STRING;
    public static final DexValueType<TypeValue> TYPE;
    public static final DexValueType<FieldIdValue> FIELD;
    public static final DexValueType<MethodIdValue> METHOD;
    public static final DexValueType<EnumValue> ENUM;
    public static final DexValueType<ArrayValue> ARRAY;
    public static final DexValueType<AnnotationValue> ANNOTATION;
    public static final DexValueType<NullValue> NULL;
    public static final DexValueType<BooleanValue> BOOLEAN;
    private final String name;
    private final int type;
    private final int size;
    private final BlockCreator<T> creator;
    private final int flag;

    private DexValueType(String name, int type, int size, BlockCreator<T> creator) {
        this.name = name;
        this.type = type;
        this.size = size;
        this.creator = creator;
        this.flag = size << 5 | type;
    }

    public int getSize() {
        return this.size;
    }

    public int getType() {
        return this.type;
    }

    public int getFlag() {
        return this.flag;
    }

    public int getFlag(int size) {
        return size << 5 | this.type;
    }

    @Override
    public T newInstance() {
        return (T)((DexValueBlock)this.creator.newInstance());
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return this.flag;
    }

    public static DexValueType<?> fromFlag(int flag) {
        return VALUES[flag & 0x1F];
    }

    public static DexValueBlock<?> create(BlockReader reader) throws IOException {
        int type = reader.read();
        reader.offset(-1);
        DexValueType<?> valueType = DexValueType.fromFlag(type);
        if (valueType == null) {
            throw new IOException("Invalid value type: " + HexUtil.toHex2((byte)type) + ", " + reader);
        }
        return valueType.newInstance();
    }

    public static int decodeSize(int flag) {
        return flag >>> 5;
    }

    public static DexValueType<?>[] values() {
        return VALUES_COPY;
    }

    public static <T1 extends IdItem> DexValueType<? extends SectionValue<T1>> get(SectionType<T1> sectionType) {
        DexValueType<SectionIdValue> obj = null;
        if (sectionType == SectionType.STRING_ID) {
            obj = STRING;
        }
        if (sectionType == SectionType.TYPE_ID) {
            obj = TYPE;
        }
        if (sectionType == SectionType.FIELD_ID) {
            obj = ENUM;
        }
        if (sectionType == SectionType.METHOD_ID) {
            obj = METHOD;
        }
        if (sectionType == SectionType.METHOD_HANDLE) {
            obj = METHOD_HANDLE;
        }
        return obj;
    }

    static {
        int i;
        DexValueType[] valueTypes = new DexValueType[32];
        VALUES = valueTypes;
        valueTypes[0] = BYTE = new DexValueType<ByteValue>("BYTE", 0, 0, ByteValue::new);
        valueTypes[2] = SHORT = new DexValueType<ShortValue>("SHORT", 2, 1, ShortValue::new);
        valueTypes[3] = CHAR = new DexValueType<CharValue>("CHAR", 3, 1, CharValue::new);
        valueTypes[4] = INT = new DexValueType<IntValue>("INT", 4, 3, IntValue::new);
        valueTypes[6] = LONG = new DexValueType<LongValue>("LONG", 6, 7, LongValue::new);
        valueTypes[16] = FLOAT = new DexValueType<FloatValue>("FLOAT", 16, 3, FloatValue::new);
        valueTypes[17] = DOUBLE = new DexValueType<DoubleValue>("DOUBLE", 17, 7, DoubleValue::new);
        valueTypes[21] = PROTO = new DexValueType<ProtoValue>("PROTO", 21, 3, ProtoValue::new);
        valueTypes[22] = METHOD_HANDLE = new DexValueType<MethodHandleValue>("METHOD_HANDLE", 22, 3, MethodHandleValue::new);
        valueTypes[23] = STRING = new DexValueType<StringValue>("STRING", 23, 3, StringValue::new);
        valueTypes[24] = TYPE = new DexValueType<TypeValue>("TYPE", 24, 3, TypeValue::new);
        valueTypes[25] = FIELD = new DexValueType<FieldIdValue>("FIELD", 25, 3, FieldIdValue::new);
        valueTypes[26] = METHOD = new DexValueType<MethodIdValue>("METHOD", 26, 3, MethodIdValue::new);
        valueTypes[27] = ENUM = new DexValueType<EnumValue>("ENUM", 27, 3, EnumValue::new);
        valueTypes[28] = ARRAY = new DexValueType<ArrayValue>("ARRAY", 28, 0, ArrayValue::new);
        valueTypes[29] = ANNOTATION = new DexValueType<AnnotationValue>("ANNOTATION", 29, 0, AnnotationValue::new);
        valueTypes[30] = NULL = new DexValueType<NullValue>("NULL", 30, 0, NullValue::new);
        valueTypes[31] = BOOLEAN = new DexValueType<BooleanValue>("BOOLEAN", 31, 1, BooleanValue::new);
        int index = 0;
        for (i = 0; i < valueTypes.length; ++i) {
            if (valueTypes[i] == null) continue;
            ++index;
        }
        VALUES_COPY = new DexValueType[index];
        index = 0;
        for (i = 0; i < valueTypes.length; ++i) {
            if (valueTypes[i] == null) continue;
            DexValueType.VALUES_COPY[index] = valueTypes[i];
            ++index;
        }
    }
}

