/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.value;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.container.FixedBlockContainer;
import com.reandroid.arsc.item.ByteItem;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliValue;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.utils.collection.EmptyIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;

public class DexValueBlock<T extends Block>
extends FixedBlockContainer
implements SmaliFormat {
    private final ByteItem valueTypeItem = new ByteItem();
    private final T valueContainer;
    private boolean mTemporary;

    DexValueBlock(T value, DexValueType<?> type) {
        super(2);
        this.valueContainer = value;
        this.addChild(0, this.valueTypeItem);
        this.addChild(1, (Block)this.valueContainer);
        this.valueTypeItem.set((byte)type.getFlag());
    }

    DexValueBlock(DexValueType<?> type) {
        this(null, type);
    }

    public boolean isTemporary() {
        return this.mTemporary;
    }

    public void setTemporary(boolean temporary) {
        this.mTemporary = temporary;
    }

    T getValueContainer() {
        return this.valueContainer;
    }

    ByteItem getValueTypeItem() {
        return this.valueTypeItem;
    }

    public DexValueType<?> getValueType() {
        return this.getValueTypeReal();
    }

    private DexValueType<?> getValueTypeReal() {
        return DexValueType.fromFlag(this.valueTypeItem.unsignedInt());
    }

    int getValueSize() {
        return DexValueType.decodeSize(this.valueTypeItem.unsignedInt());
    }

    void setValueSize(int size) {
        int flag = this.getValueType().getFlag(size);
        this.valueTypeItem.set((byte)flag);
    }

    public void replaceKeys(Key search, Key replace) {
    }

    public Iterator<IdItem> usedIds() {
        return EmptyIterator.of();
    }

    public void merge(DexValueBlock<?> valueBlock) {
        this.valueTypeItem.set(valueBlock.valueTypeItem.get());
    }

    public void fromSmali(SmaliValue smaliValue) {
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        T value = this.getValueContainer();
        if (value instanceof SmaliFormat) {
            ((SmaliFormat)value).append(writer);
        }
    }

    public String getAsString() {
        return String.valueOf(this.getValueContainer());
    }

    public boolean is(DexValueType<?> dexValueType) {
        return dexValueType == this.getValueType();
    }

    public TypeKey getDataTypeKey() {
        return TypeKey.OBJECT;
    }

    public Object getData() {
        return null;
    }

    public void setData(Object data) {
        throw new RuntimeException("Method not implemented");
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this.getValueType().getType();
        hash = hash * 31 + this.getValueContainer().hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DexValueBlock value = (DexValueBlock)obj;
        return Objects.equals(this.getValueContainer(), value.getValueContainer());
    }

    public String toString() {
        return String.valueOf(this.getValueContainer());
    }
}

