/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.value;

import com.reandroid.dex.common.DexUtils;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliValue;
import com.reandroid.dex.smali.model.SmaliValueChar;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.dex.value.PrimitiveValueBlock;
import com.reandroid.utils.HexUtil;
import java.io.IOException;

public class CharValue
extends PrimitiveValueBlock {
    public CharValue() {
        super(DexValueType.CHAR);
    }

    @Override
    public Number getData() {
        int i = (int)this.getNumberValue();
        if ((i & 0xFF) == i) {
            return (byte)i;
        }
        if ((i & 0xFFFF) == i) {
            return (short)i;
        }
        return i;
    }

    @Override
    public void setData(Number number) {
        if (number == null) {
            throw new NullPointerException();
        }
        if (number instanceof Integer) {
            Integer v = (Integer)number;
            this.set((char)v.intValue());
        } else if (number instanceof Short) {
            Short v = (Short)number;
            int i = v & 0xFFFF;
            this.set((char)i);
        } else if (number instanceof Byte) {
            Byte v = (Byte)number;
            int i = v & 0xFF;
            this.set((char)i);
        }
        throw new NumberFormatException("Invalid '" + number.getClass().getSimpleName() + "' value for char " + number);
    }

    public char get() {
        return (char)this.getNumberValue();
    }

    public void set(char ch) {
        this.setNumberValue(0xFFFF & ch);
    }

    @Override
    public DexValueType<?> getValueType() {
        return DexValueType.CHAR;
    }

    @Override
    public String getHex() {
        return HexUtil.toHex(this.getNumberValue(), this.getValueSize()) + "C";
    }

    @Override
    public String getAsString() {
        return DexUtils.quoteChar(this.get());
    }

    @Override
    public TypeKey getDataTypeKey() {
        return TypeKey.TYPE_C;
    }

    @Override
    public void fromSmali(SmaliValue smaliValue) {
        SmaliValueChar smaliValueChar = (SmaliValueChar)smaliValue;
        this.set(smaliValueChar.getValue());
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        DexUtils.appendSingleQuotedChar(writer, this.get());
    }

    @Override
    public String toString() {
        return this.getAsString();
    }
}

