/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.value;

import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.model.SmaliValue;
import com.reandroid.dex.smali.model.SmaliValueByte;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.dex.value.NumberValue;
import com.reandroid.dex.value.PrimitiveValueBlock;
import com.reandroid.utils.HexUtil;

public class ByteValue
extends PrimitiveValueBlock {
    public ByteValue() {
        super(DexValueType.BYTE);
    }

    @Override
    public Byte getData() {
        return this.get();
    }

    @Override
    public void setData(Number number) {
        this.set((Byte)number);
    }

    public byte get() {
        return (byte)(this.getNumberValue() & 0xFFL);
    }

    public void set(byte b) {
        ((NumberValue)this.getValueContainer()).setNumberValue(b);
    }

    @Override
    public DexValueType<?> getValueType() {
        return DexValueType.BYTE;
    }

    @Override
    public String getHex() {
        return HexUtil.toHex(this.getNumberValue(), 1) + "t";
    }

    @Override
    public TypeKey getDataTypeKey() {
        return TypeKey.TYPE_B;
    }

    @Override
    public void fromSmali(SmaliValue smaliValue) {
        SmaliValueByte smaliValueByte = (SmaliValueByte)smaliValue;
        this.set(smaliValueByte.getValue());
    }
}

