/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.value;

import com.reandroid.arsc.base.Block;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.value.DexValueBlock;
import com.reandroid.dex.value.DexValueType;
import java.io.IOException;

public class BooleanValue
extends DexValueBlock<Block> {
    public BooleanValue() {
        super(DexValueType.BOOLEAN);
    }

    public boolean get() {
        return this.getValueSize() == 1;
    }

    public void set(boolean value) {
        this.setValueSize(value ? 1 : 0);
    }

    @Override
    public DexValueType<?> getValueType() {
        return DexValueType.BOOLEAN;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.append(Boolean.toString(this.get()));
    }

    @Override
    public String getAsString() {
        return Boolean.toString(this.get());
    }

    @Override
    public TypeKey getDataTypeKey() {
        return TypeKey.TYPE_Z;
    }

    @Override
    public Boolean getData() {
        if (this.get()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public void setData(Object data) {
        this.set((Boolean)data);
    }

    @Override
    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this.getValueType().getType();
        hash = hash * 31 + this.getValueSize();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BooleanValue value = (BooleanValue)obj;
        return this.get() == value.get();
    }

    @Override
    public String toString() {
        return this.getAsString();
    }
}

