/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliValueNumber;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.utils.HexUtil;
import java.io.IOException;

public class SmaliValueShort
extends SmaliValueNumber<Short> {
    private short value;

    public SmaliValueShort() {
        this(0);
    }

    public SmaliValueShort(short sh) {
        this.value = sh;
    }

    public short getValue() {
        return this.value;
    }

    public void setValue(short value) {
        this.value = value;
    }

    @Override
    public Short getNumber() {
        return this.getValue();
    }

    @Override
    public void setNumber(Short number) {
        this.setValue(number);
    }

    @Override
    public int getWidth() {
        return 2;
    }

    @Override
    public int unsignedInt() {
        return this.getValue() & 0xFFFF;
    }

    @Override
    public long unsignedLong() {
        return (long)this.getValue() & 0xFFFFL;
    }

    @Override
    public DexValueType<?> getValueType() {
        return DexValueType.SHORT;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.appendHex(this.getValue());
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        short s;
        reader.skipSpaces();
        int position = reader.position();
        try {
            s = HexUtil.parseHexShort(reader.readStringForNumber());
        }
        catch (NumberFormatException ex) {
            reader.position(position);
            throw new SmaliParseException(ex.getMessage(), reader);
        }
        this.setValue(s);
    }
}

