/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.model.SmaliValue;
import com.reandroid.dex.smali.model.SmaliValueByte;
import com.reandroid.dex.smali.model.SmaliValueDouble;
import com.reandroid.dex.smali.model.SmaliValueFloat;
import com.reandroid.dex.smali.model.SmaliValueInteger;
import com.reandroid.dex.smali.model.SmaliValueLong;
import com.reandroid.dex.smali.model.SmaliValueShort;
import java.io.IOException;

public abstract class SmaliValueNumber<T extends Number>
extends SmaliValue {
    public abstract T getNumber();

    public abstract void setNumber(T var1);

    public abstract int getWidth();

    public abstract int unsignedInt();

    public abstract long unsignedLong();

    public static <T1 extends Number> SmaliValueNumber<T1> createFor(T1 number) {
        return SmaliValueNumber.createUnchecked(number);
    }

    private static SmaliValueNumber<?> createUnchecked(Number number) {
        if (number == null) {
            throw new NullPointerException();
        }
        if (number instanceof Byte) {
            return new SmaliValueByte((Byte)number);
        }
        if (number instanceof Short) {
            return new SmaliValueShort((Short)number);
        }
        if (number instanceof Integer) {
            return new SmaliValueInteger((Integer)number);
        }
        if (number instanceof Long) {
            return new SmaliValueLong((Long)number);
        }
        if (number instanceof Float) {
            return new SmaliValueFloat(((Float)number).floatValue());
        }
        if (number instanceof Double) {
            return new SmaliValueDouble((Double)number);
        }
        throw new RuntimeException("Unrecognized number class: " + number.getClass());
    }

    public static SmaliValueNumber<?> createNumber(SmaliReader reader) throws IOException {
        reader.skipSpaces();
        int position = reader.position();
        byte b = reader.get(position);
        if (b == 45 || b == 43) {
            b = reader.get(++position);
        }
        if (b == 48 && reader.get(position + 1) == 120) {
            b = reader.get(reader.indexOfWhiteSpaceOrComment() - 1);
            if (b == 116) {
                return new SmaliValueByte();
            }
            if (b == 83 || b == 115) {
                return new SmaliValueShort();
            }
            if (b == 76) {
                return new SmaliValueLong();
            }
            return new SmaliValueInteger();
        }
        byte[] infinity = new byte[]{73, 110, 102, 105, 110, 105, 116, 121};
        if (reader.startsWith(infinity, position)) {
            b = reader.get(infinity.length + position);
            if (b == 102) {
                return new SmaliValueFloat();
            }
            return new SmaliValueDouble();
        }
        byte[] nan = new byte[]{78, 97, 78};
        if (reader.startsWith(nan, position)) {
            b = reader.get(nan.length + position);
            if (b == 102) {
                return new SmaliValueFloat();
            }
            return new SmaliValueDouble();
        }
        if (b <= 57 && b >= 48) {
            b = reader.get(reader.indexOfWhiteSpaceOrComment() - 1);
            if (b == 102) {
                return new SmaliValueFloat();
            }
            return new SmaliValueDouble();
        }
        throw new SmaliParseException("Unrecognized number format", reader);
    }
}

