/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliValueNumber;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.utils.HexUtil;
import java.io.IOException;

public class SmaliValueLong
extends SmaliValueNumber<Long> {
    private long value;

    public SmaliValueLong() {
        this(0L);
    }

    public SmaliValueLong(long l) {
        this.value = l;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    @Override
    public Long getNumber() {
        return this.getValue();
    }

    @Override
    public void setNumber(Long number) {
        this.setValue(number);
    }

    @Override
    public int getWidth() {
        return 8;
    }

    @Override
    public int unsignedInt() {
        return (int)this.getValue();
    }

    @Override
    public long unsignedLong() {
        return this.getValue();
    }

    @Override
    public DexValueType<?> getValueType() {
        return DexValueType.LONG;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.appendHex(this.getValue());
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        long l;
        reader.skipSpaces();
        int position = reader.position();
        try {
            l = HexUtil.parseHexLong(reader.readStringForNumber());
        }
        catch (NumberFormatException ex) {
            reader.position(position);
            throw new SmaliParseException(ex.getMessage(), reader);
        }
        this.setValue(l);
    }
}

