/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliValueNumber;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.utils.HexUtil;
import java.io.IOException;

public class SmaliValueInteger
extends SmaliValueNumber<Integer> {
    private int value;

    public SmaliValueInteger() {
        this(0);
    }

    public SmaliValueInteger(int i) {
        this.value = i;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    @Override
    public Integer getNumber() {
        return this.getValue();
    }

    @Override
    public void setNumber(Integer number) {
        this.setValue(number);
    }

    @Override
    public int getWidth() {
        return 4;
    }

    @Override
    public int unsignedInt() {
        return this.getValue();
    }

    @Override
    public long unsignedLong() {
        return (long)this.getValue() & 0xFFFFFFFFL;
    }

    @Override
    public DexValueType<?> getValueType() {
        return DexValueType.INT;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.appendHex(this.getValue());
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        int i;
        reader.skipSpaces();
        int position = reader.position();
        try {
            i = HexUtil.parseHexInteger(reader.readStringForNumber());
        }
        catch (NumberFormatException ex) {
            reader.position(position);
            throw new SmaliParseException("Invalid hex integer", reader);
        }
        this.setValue(i);
    }
}

