/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliValueNumber;
import com.reandroid.dex.value.DexValueType;
import java.io.IOException;

public class SmaliValueFloat
extends SmaliValueNumber<Float> {
    private float value;
    public static final byte[] POSITIVE_INFINITY = new byte[]{73, 110, 102, 105, 110, 105, 116, 121, 102};
    public static final byte[] NEGATIVE_INFINITY = new byte[]{45, 73, 110, 102, 105, 110, 105, 116, 121, 102};
    public static final byte[] NAN = new byte[]{78, 97, 78, 102};

    public SmaliValueFloat() {
        this(0.0f);
    }

    public SmaliValueFloat(float f) {
        this.value = f;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    @Override
    public Float getNumber() {
        return Float.valueOf(this.getValue());
    }

    @Override
    public void setNumber(Float number) {
        this.setValue(number.floatValue());
    }

    @Override
    public int getWidth() {
        return 4;
    }

    @Override
    public int unsignedInt() {
        return this.getNumber().intValue();
    }

    @Override
    public long unsignedLong() {
        return (long)this.getNumber().intValue() & 0xFFFFFFFFL;
    }

    @Override
    public DexValueType<?> getValueType() {
        return DexValueType.FLOAT;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.append(this.getValue());
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        float f;
        reader.skipSpaces();
        int position = reader.position();
        try {
            if (reader.startsWith(POSITIVE_INFINITY)) {
                reader.skip(POSITIVE_INFINITY.length);
                f = Float.POSITIVE_INFINITY;
            } else if (reader.startsWith(NEGATIVE_INFINITY)) {
                reader.skip(NEGATIVE_INFINITY.length);
                f = Float.NEGATIVE_INFINITY;
            } else if (reader.startsWith(NAN)) {
                reader.skip(NAN.length);
                f = Float.NaN;
            } else {
                f = Float.parseFloat(reader.readStringForNumber());
            }
        }
        catch (NumberFormatException ex) {
            reader.position(position);
            throw new SmaliParseException(ex.getMessage(), reader);
        }
        this.setValue(f);
    }
}

