/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliValueNumber;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.utils.HexUtil;
import java.io.IOException;

public class SmaliValueByte
extends SmaliValueNumber<Byte> {
    private byte value;

    public SmaliValueByte() {
        this(0);
    }

    public SmaliValueByte(byte b) {
        this.value = b;
    }

    public byte getValue() {
        return this.value;
    }

    public void setValue(byte value) {
        this.value = value;
    }

    @Override
    public Byte getNumber() {
        return this.getValue();
    }

    @Override
    public void setNumber(Byte number) {
        this.setValue(number);
    }

    @Override
    public int getWidth() {
        return 1;
    }

    @Override
    public int unsignedInt() {
        return this.getValue() & 0xFF;
    }

    @Override
    public long unsignedLong() {
        return (long)this.getValue() & 0xFFL;
    }

    @Override
    public DexValueType<?> getValueType() {
        return DexValueType.BYTE;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.appendHex(this.getValue());
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        byte b;
        reader.skipSpaces();
        int position = reader.position();
        try {
            b = HexUtil.parseHexByte(reader.readStringForNumber());
        }
        catch (NumberFormatException ex) {
            reader.position(position);
            throw new SmaliParseException(ex.getMessage(), reader);
        }
        this.setValue(b);
    }
}

