/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.model.Smali;
import com.reandroid.dex.smali.model.SmaliValueAnnotation;
import com.reandroid.dex.smali.model.SmaliValueArray;
import com.reandroid.dex.smali.model.SmaliValueBoolean;
import com.reandroid.dex.smali.model.SmaliValueByte;
import com.reandroid.dex.smali.model.SmaliValueChar;
import com.reandroid.dex.smali.model.SmaliValueDouble;
import com.reandroid.dex.smali.model.SmaliValueEnum;
import com.reandroid.dex.smali.model.SmaliValueFloat;
import com.reandroid.dex.smali.model.SmaliValueInteger;
import com.reandroid.dex.smali.model.SmaliValueKey;
import com.reandroid.dex.smali.model.SmaliValueLong;
import com.reandroid.dex.smali.model.SmaliValueNull;
import com.reandroid.dex.smali.model.SmaliValueShort;
import com.reandroid.dex.value.DexValueType;
import java.io.IOException;

public class SmaliValue
extends Smali {
    public DexValueType<?> getValueType() {
        return null;
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
    }

    public static SmaliValue create(SmaliReader reader) throws IOException {
        reader.skipSpaces();
        int position = reader.position();
        byte b = reader.get(position);
        if (b == 46) {
            SmaliDirective directive = SmaliDirective.parse(reader, false);
            if (directive == SmaliDirective.ENUM) {
                return new SmaliValueEnum();
            }
            if (directive == SmaliDirective.SUB_ANNOTATION) {
                return new SmaliValueAnnotation();
            }
            throw new SmaliParseException("Unrecognized value", reader);
        }
        if (b == 123) {
            return new SmaliValueArray();
        }
        if (b == 39) {
            return new SmaliValueChar();
        }
        if (b == 110) {
            return new SmaliValueNull();
        }
        if (b == 116 || b == 102) {
            return new SmaliValueBoolean();
        }
        if (b == 45 || b == 43) {
            b = reader.get(++position);
        }
        if (b == 48 && reader.get(position + 1) == 120) {
            b = reader.get(reader.indexOfWhiteSpaceOrComment() - 1);
            if (b == 116) {
                return new SmaliValueByte();
            }
            if (b == 83 || b == 115) {
                return new SmaliValueShort();
            }
            if (b == 76) {
                return new SmaliValueLong();
            }
            return new SmaliValueInteger();
        }
        byte[] infinity = new byte[]{73, 110, 102, 105, 110, 105, 116, 121};
        if (reader.startsWith(infinity, position)) {
            b = reader.get(infinity.length + position);
            if (b == 102) {
                return new SmaliValueFloat();
            }
            return new SmaliValueDouble();
        }
        byte[] nan = new byte[]{78, 97, 78};
        if (reader.startsWith(nan, position)) {
            b = reader.get(nan.length + position);
            if (b == 102) {
                return new SmaliValueFloat();
            }
            return new SmaliValueDouble();
        }
        if (b <= 57 && b >= 48) {
            b = reader.get(reader.indexOfWhiteSpaceOrComment() - 1);
            if (b == 102) {
                return new SmaliValueFloat();
            }
            return new SmaliValueDouble();
        }
        return new SmaliValueKey();
    }
}

