/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.Smali;
import com.reandroid.dex.smali.model.SmaliLabel;
import com.reandroid.dex.smali.model.SmaliValueNumber;
import java.io.IOException;

public class SmaliSparseSwitchEntry
extends Smali {
    private SmaliValueNumber<?> value;
    private final SmaliLabel label = new SmaliLabel();

    public SmaliSparseSwitchEntry() {
        this.label.setParent(this);
    }

    public int getIntegerValue() {
        return this.getValueNumber().unsignedInt();
    }

    public Number getValue() {
        return this.getValueNumber().getNumber();
    }

    public void setValue(Number value) {
        this.setNumberValue(SmaliValueNumber.createFor(value));
    }

    public SmaliValueNumber<?> getValueNumber() {
        return this.value;
    }

    public void setNumberValue(SmaliValueNumber<?> valueNumber) {
        this.value = valueNumber;
        if (valueNumber != null) {
            valueNumber.setParent(this);
        }
    }

    public SmaliLabel getLabel() {
        return this.label;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.appendOptional(this.getValueNumber());
        writer.append(" -> ");
        this.getLabel().append(writer);
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        reader.skipWhitespacesOrComment();
        SmaliValueNumber<?> value = SmaliValueNumber.createNumber(reader);
        this.setNumberValue(value);
        value.parse(reader);
        reader.skipSpaces();
        SmaliParseException.expect(reader, '-');
        SmaliParseException.expect(reader, '>');
        reader.skipSpaces();
        this.getLabel().parse(reader);
    }
}

